/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.v1_18_R2.biome;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.Biomes;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.plugin.java.JavaPlugin;

public final class CustomBiome {
    private final DedicatedServer server;
    private final IRegistryWritable<BiomeBase> registry;
    private Holder<BiomeBase> holder;
    private BiomeBase biome;
    private BiomeBase.a builder;
    private String name;
    private int skyColor;
    private int fogColor;
    private int waterColor;
    private int waterFogColor;
    private int foliageColor;
    private int grassColor;
    private float temperature;

    public CustomBiome(JavaPlugin instance) {
        this.server = ((CraftServer)instance.getServer()).getServer();
        this.registry = (IRegistryWritable)this.server.aU().b(IRegistry.aP);
    }

    private void register(ResourceKey<BiomeBase> key, BiomeBase biome) {
        this.setFrozen(false);
        this.registry.a(key, (Object)biome, Lifecycle.stable());
        this.holder = RegistryGeneration.a((IRegistry)RegistryGeneration.i, key, (Object)biome);
        this.setFrozen(true);
    }

    public Holder<BiomeBase> getHolder() {
        return this.holder;
    }

    private void setFrozen(boolean state) {
        try {
            RegistryMaterials materials = (RegistryMaterials)this.server.aU().b(IRegistry.aP);
            Field isFrozen = materials.getClass().getDeclaredField("bL");
            isFrozen.setAccessible(true);
            isFrozen.set(materials, state);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CustomBiome build() {
        this.builder = new BiomeBase.a();
        ResourceKey key = ResourceKey.a((ResourceKey)IRegistry.aP, (MinecraftKey)new MinecraftKey("vivaldi", this.name));
        this.copyDefaultSettings();
        this.applyEffectsAndBuild();
        this.register((ResourceKey<BiomeBase>)key, this.biome);
        return this;
    }

    private void copyDefaultSettings() {
        this.builder.a(Objects.requireNonNull((BiomeBase)this.registry.a(Biomes.h)).b());
        this.builder.a(Objects.requireNonNull((BiomeBase)this.registry.a(Biomes.a)).e());
        this.builder.a((double)this.temperature >= 0.95 ? BiomeBase.Precipitation.a : BiomeBase.Precipitation.b);
        this.builder.a(BiomeBase.TemperatureModifier.a);
        this.builder.b(0.0f);
        this.builder.a(BiomeBase.Geography.k);
    }

    private void applyEffectsAndBuild() {
        BiomeFog.a effects = new BiomeFog.a();
        effects.a(this.fogColor).d(this.skyColor).b(this.waterColor).c(this.waterFogColor);
        effects.e(this.foliageColor).f(this.grassColor);
        this.builder.a(this.temperature);
        this.builder.a(effects.a());
        this.biome = this.builder.a();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSkyColor(int skyColor) {
        this.skyColor = skyColor;
    }

    public void setFogColor(int fogColor) {
        this.fogColor = fogColor;
    }

    public void setWaterColor(int waterColor) {
        this.waterColor = waterColor;
    }

    public void setWaterFogColor(int waterFogColor) {
        this.waterFogColor = waterFogColor;
    }

    public void setFoliageColor(int foliageColor) {
        this.foliageColor = foliageColor;
    }

    public void setGrassColor(int grassColor) {
        this.grassColor = grassColor;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }
}

