/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.season;

import java.io.File;
import java.io.IOException;
import me.nologic.vivaldi.season.Season;
import me.nologic.vivaldi.season.util.TimerTask;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SeasonAPI {
    public static SeasonAPI instance;
    private final JavaPlugin plugin;
    private final YamlConfiguration yaml;
    private final int duration;
    private int date;
    private Season season;

    public SeasonAPI(JavaPlugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.yaml = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder() + "/", "date.yml"));
        this.duration = plugin.getConfig().getInt("gameplay-settings.season-duration");
        this.season = Season.valueOf(this.yaml.getString("season"));
        this.date = this.yaml.getInt("date");
    }

    public void enable(World world) {
        new TimerTask(this, world).runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public Season getCurrentSeason() {
        return this.season;
    }

    public int getCurrentDate() {
        return this.date;
    }

    public int getSeasonDuration() {
        return this.duration;
    }

    public void setSeason(Season season) {
        try {
            this.yaml.set("season", (Object)season.toString());
            this.yaml.save(new File(this.plugin.getDataFolder(), "date.yml"));
            this.setDate(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.season = season;
    }

    public void setDate(int date) {
        try {
            this.yaml.set("date", (Object)date);
            this.yaml.save(new File(this.plugin.getDataFolder(), "date.yml"));
            this.date = date;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static SeasonAPI getInstance() {
        return instance;
    }
}

