/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.language;

import java.io.File;
import me.nologic.vivaldi.season.Season;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class LanguageProvider {
    private static LanguageProvider instance;
    private final JavaPlugin plugin;
    private YamlConfiguration lang;

    public LanguageProvider(JavaPlugin plugin) {
        instance = this;
        this.plugin = plugin;
    }

    public void load() {
        String file = this.plugin.getConfig().getString("main-settings.language");
        this.lang = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder() + "/languages/" + file + ".yml"));
        this.plugin.getLogger().info("Language file " + file + ".yml is loaded successfully!");
    }

    public YamlConfiguration getLanguageFile() {
        return this.lang;
    }

    public static LanguageProvider getInstance() {
        return instance;
    }

    public String getLocalizedSeasonName(Season season) {
        return this.lang.getString(season.toString().toLowerCase());
    }
}

