/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.core;

import me.nologic.vivaldi.language.LanguageProvider;
import me.nologic.vivaldi.season.SeasonAPI;
import me.nologic.vivaldi.season.event.DateChangeEvent;
import me.nologic.vivaldi.season.event.SeasonChangeEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class SeasonListener
implements Listener {
    @EventHandler
    private void onDateChange(DateChangeEvent event) {
        SeasonAPI seasonAPI = SeasonAPI.getInstance();
        if (event.getDate() == event.getSeasonDuration()) {
            Bukkit.getPluginManager().callEvent((Event)new SeasonChangeEvent(event.getCurrentSeason(), event.getWorld(), false));
        } else {
            seasonAPI.setDate(event.getDate() + 1);
            String message = LanguageProvider.getInstance().getLanguageFile().getString("broadcast-new-day", "");
            String broadcast = String.format(message, event.getDate(), LanguageProvider.getInstance().getLocalizedSeasonName(event.getCurrentSeason()));
            Bukkit.getOnlinePlayers().forEach(p -> p.sendMessage(broadcast));
        }
    }

    @EventHandler
    private void onSeasonChange(SeasonChangeEvent event) {
        SeasonAPI seasonAPI = SeasonAPI.getInstance();
        if (event.isCommand()) {
            seasonAPI.setSeason(event.getSeason());
        } else {
            seasonAPI.setSeason(event.getNextSeason());
        }
        String message = LanguageProvider.getInstance().getLanguageFile().getString("broadcast-new-season", "");
        String broadcast = String.format(message, LanguageProvider.getInstance().getLocalizedSeasonName(event.getSeason()));
        Bukkit.getOnlinePlayers().forEach(p -> p.sendMessage(broadcast));
    }
}

