/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.command;

import java.util.IllegalFormatConversionException;
import java.util.List;
import me.nologic.vivaldi.Vivaldi;
import me.nologic.vivaldi.language.LanguageProvider;
import me.nologic.vivaldi.season.Season;
import me.nologic.vivaldi.season.event.SeasonChangeEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;

public record CommandHandler(Vivaldi instance) implements CommandExecutor
{
    public CommandHandler(Vivaldi instance) {
        this.instance = instance;
        instance.getCommand("vivaldi").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CommandOrder order;
        YamlConfiguration lang = this.instance.getLanguage();
        List helpMessage = lang.getStringList("command-help-message");
        try {
            order = CommandOrder.valueOf(args[0].toUpperCase());
        }
        catch (Exception ex) {
            helpMessage.forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
            return true;
        }
        switch (order) {
            default: {
                helpMessage.forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                break;
            }
            case RELOAD: 
            case R: {
                this.instance.reload();
                sender.sendMessage(lang.getString("info-plugin-reloaded", ""));
                return true;
            }
            case SETSEASON: 
            case SS: {
                Season season;
                try {
                    season = Season.valueOf(args[1].toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    sender.sendMessage(String.format(lang.getString("error-command-non-existing-season", ""), args[1]));
                    return true;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    sender.sendMessage(lang.getString("error-command-season-not-entered", ""));
                    return true;
                }
                this.setSeason(season);
                sender.sendMessage(String.format(lang.getString("info-season-is-changed-by-command", ""), LanguageProvider.getInstance().getLocalizedSeasonName(season)));
                break;
            }
            case SETDATE: 
            case SD: {
                int date;
                try {
                    date = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException | IllegalFormatConversionException ex) {
                    sender.sendMessage(String.format(lang.getString("error-command-not-a-number", ""), args[1]));
                    return true;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    sender.sendMessage(lang.getString("error-command-number-not-entered", ""));
                    return true;
                }
                if (date > this.instance.getSignature().getSeasonAPI().getSeasonDuration() || date < 1) {
                    sender.sendMessage(lang.getString("error-command-wrong-number", ""));
                    return true;
                }
                this.setDate(date);
                sender.sendMessage(String.format(lang.getString("info-date-is-changed-by-command", ""), date, this.instance.getSignature().getSeasonAPI().getCurrentSeason().toString().toLowerCase()));
            }
        }
        return true;
    }

    private void setDate(int date) {
        this.instance.getSignature().getSeasonAPI().setDate(date);
    }

    private void setSeason(Season season) {
        Bukkit.getPluginManager().callEvent((Event)new SeasonChangeEvent(season, this.instance.getWorld(), true));
    }

    private static enum CommandOrder {
        SETSEASON,
        SETDATE,
        RELOAD,
        SS,
        SD,
        R;

    }
}

