/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import me.nologic.vivaldi.command.CommandHandler;
import me.nologic.vivaldi.core.Signature;
import me.nologic.vivaldi.core.Version;
import me.nologic.vivaldi.language.LanguageProvider;
import me.nologic.vivaldi.util.PAPISupport;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class Vivaldi
extends JavaPlugin {
    private Signature signature;
    private LanguageProvider language;
    private World world;

    public void onLoad() {
        this.checkFiles();
        this.loadLanguage();
        this.loadSignature();
        this.signature.init();
    }

    public void onEnable() {
        this.checkWorld();
        this.signature.enable();
        new CommandHandler(this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PAPISupport(this).register();
        }
    }

    public void loadLanguage() {
        this.language = new LanguageProvider(this);
        this.language.load();
    }

    private void loadSignature() {
        this.signature = Version.build(this);
    }

    private void checkWorld() {
        String worldName = this.getConfig().getString("main-settings.world");
        if (worldName != null) {
            this.world = Bukkit.getWorld((String)worldName);
            super.getLogger().info(String.format("Vivaldi will work in world %s!", worldName));
        } else {
            super.getLogger().severe("World is null!");
        }
    }

    public void onDisable() {
        this.signature.getGameplayManager().disable();
    }

    public Signature getSignature() {
        return this.signature;
    }

    private void checkFiles() {
        super.saveDefaultConfig();
        super.saveResource("date.yml", false);
        this.saveLanguageFile("en.yml");
        this.saveLanguageFile("ru.yml");
    }

    public World getWorld() {
        return this.world;
    }

    public YamlConfiguration getLanguage() {
        return this.language.getLanguageFile();
    }

    public void saveLanguageFile(@NotNull String resourcePath) {
        if (resourcePath.equals("")) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        InputStream in = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in " + this.getFile());
        }
        File outFile = new File(this.getDataFolder() + "/languages", resourcePath);
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(this.getDataFolder() + "/languages", resourcePath.substring(0, Math.max(lastIndex, 0)));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists()) {
                int len;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + outFile, ex);
        }
    }

    public void reload() {
        this.reloadConfig();
        this.language.load();
    }
}

