/*
 * Decompiled with CFR 0.152.
 */
package me.kylehunady;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.Arrays;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;

public class GossipHandler
implements Listener {
    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        String[] gossipTypes;
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Villager) && !(entity instanceof ZombieVillager)) {
            return;
        }
        if (!NBTEditor.contains(entity, "Gossips", 0)) {
            return;
        }
        Player player = event.getPlayer();
        for (String type : gossipTypes = new String[]{"minor_positive", "major_positive"}) {
            this.addPlayerToGossip(player, entity, type);
        }
    }

    private void addPlayerToGossip(Player player, Entity entity, String gossipType) {
        int maxValue = 0;
        int playerIndex = -1;
        int playerValue = 0;
        NBTEditor.NBTCompound gossips = NBTEditor.getNBTCompound(entity, "Gossips");
        int size = NBTEditor.getSize(gossips, new Object[0]);
        int[] playerId = NBTEditor.getIntArray(player, "UUID");
        for (int i = 0; i < size; ++i) {
            if (!NBTEditor.getString(gossips, i, "Type").equals(gossipType)) continue;
            int val = NBTEditor.getInt(gossips, i, "Value");
            int n = maxValue = val > maxValue ? val : maxValue;
            if (!Arrays.equals(playerId, NBTEditor.getIntArray(gossips, i, "Target"))) continue;
            playerIndex = i;
            playerValue = val;
        }
        if (maxValue <= 0) {
            return;
        }
        if (playerValue == maxValue) {
            return;
        }
        NBTEditor.NBTCompound newGossipEntry = NBTEditor.getEmptyNBTCompound();
        newGossipEntry.set(playerId, "Target");
        newGossipEntry.set(gossipType, "Type");
        newGossipEntry.set(maxValue, "Value");
        if (playerIndex >= 0) {
            NBTEditor.set(entity, newGossipEntry, "Gossips", playerIndex);
        } else {
            NBTEditor.set(entity, newGossipEntry, new Object[]{"Gossips", NBTEditor.NEW_ELEMENT});
        }
    }
}

