/*
 * Decompiled with CFR 0.152.
 */
package fr.x9nico.viacheckconnection.bungee;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import net.md_5.bungee.api.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class BungeeUpdater {
    public static boolean checkForUpdate(Plugin pl, int spigotResourceID, boolean downloadIfAvailable) {
        Double currentVersion;
        Double versionName;
        boolean update = false;
        try {
            JSONArray versions = BungeeUpdater.getArray(spigotResourceID);
            if (versions.size() == 0) {
                return update;
            }
            JSONObject latest = (JSONObject)versions.get(versions.size() - 1);
            versionName = Double.parseDouble(latest.get((Object)"name").toString());
            currentVersion = Double.parseDouble(pl.getDescription().getVersion());
        }
        catch (NumberFormatException e) {
            return update;
        }
        if (versionName > currentVersion) {
            update = true;
            if (downloadIfAvailable) {
                BungeeUpdater.download(pl, spigotResourceID);
            }
        }
        return update;
    }

    private static JSONArray getArray(int spigotResourceID) {
        JSONArray array = new JSONArray();
        try {
            array = (JSONArray)JSONValue.parseWithException((String)BungeeUpdater.connect(spigotResourceID));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return array;
    }

    private static String connect(int spigotResourceID) {
        String json = "[]";
        try {
            String buffer;
            URL versionURL = new URL("https://api.spiget.org/v2/resources/" + spigotResourceID + "/versions");
            URLConnection conn = versionURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String input = "";
            while ((buffer = in.readLine()) != null) {
                input = input + buffer;
            }
            in.close();
            json = input;
        }
        catch (IOException e) {
            return json;
        }
        return json;
    }

    public static boolean download(Plugin pl, int spigotResourceID) {
        File jar = new File(pl.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        try {
            URL url = new URL("https://api.spiget.org/v2/resources/" + spigotResourceID + "/download");
            ReadableByteChannel rbc = Channels.newChannel(url.openStream());
            FileOutputStream fos = new FileOutputStream(jar, false);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

