/*
 * Decompiled with CFR 0.152.
 */
package blacklce.me;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class ItemManager {
    private ItemStack item;
    private List<String> lore = new ArrayList<String>();
    private ItemMeta meta;

    public ItemManager(Material mat, short subid, int amount) {
        this.item = new ItemStack(mat, amount, subid);
        this.meta = this.item.getItemMeta();
    }

    public ItemManager(ItemStack item) {
        this.item = item;
        this.meta = item.getItemMeta();
    }

    public ItemManager(Material mat, short subid) {
        this.item = new ItemStack(mat, 1, subid);
        this.meta = this.item.getItemMeta();
    }

    public ItemManager(Material mat, int amount) {
        this.item = new ItemStack(mat, amount, 0);
        this.meta = this.item.getItemMeta();
    }

    public ItemManager(Material mat) {
        this.item = new ItemStack(mat, 1, 0);
        this.meta = this.item.getItemMeta();
    }

    public ItemManager setAmount(int value) {
        this.item.setAmount(value);
        return this;
    }

    public ItemManager setNoName() {
        this.meta.setDisplayName("   ");
        return this;
    }

    public ItemManager setData(short data) {
        this.item.setDurability(data);
        return this;
    }

    public ItemManager addLoreLine(String line) {
        this.lore.add(line);
        return this;
    }

    public ItemManager setDisplayName(String name) {
        this.meta.setDisplayName(name);
        return this;
    }

    public ItemManager setLocalizedName(String name) {
        this.meta.setLocalizedName(name);
        return this;
    }

    public ItemManager setColor(Color c) {
        ((LeatherArmorMeta)this.meta).setColor(c);
        return this;
    }

    public ItemManager addEnchantment(Enchantment ench, int lvl) {
        this.meta.addEnchant(ench, lvl, true);
        return this;
    }

    public ItemManager addItemFlag(ItemFlag flag) {
        this.meta.addItemFlags(new ItemFlag[]{flag});
        return this;
    }

    public ItemStack build() {
        if (!this.lore.isEmpty()) {
            this.meta.setLore(this.lore);
        }
        this.item.setItemMeta(this.meta);
        return this.item;
    }
}

