/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.worldguard;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.util.Problem;
import be.isach.ultracosmetics.util.ServerVersion;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.worldguard.CosmeticRegionState;
import be.isach.ultracosmetics.worldguard.IFlagManager;
import be.isach.ultracosmetics.worldguard.UCFlag;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class WorldGuardManager {
    protected boolean registered = false;
    private IFlagManager flagManager;

    public void register(UltraCosmetics ultraCosmetics) {
        String path = "be.isach.ultracosmetics.worldguard.";
        if (!UltraCosmeticsData.get().getServerVersion().isAtLeast(ServerVersion.v1_13)) {
            path = path + "legacy.";
        }
        try {
            this.flagManager = (IFlagManager)Class.forName(path + "FlagManager").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodError | NoSuchMethodException e) {
            ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Couldn't find required classes for WorldGuard integration.");
            ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Please make sure you are using the latest version of WorldGuard");
            ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "for your version of Minecraft. Debug info:");
            e.printStackTrace();
            ultraCosmetics.getSmartLogger().write("WorldGuard support is disabled.");
            ultraCosmetics.addProblem(Problem.WORLDGUARD_HOOK_FAILURE);
            return;
        }
        this.flagManager.register();
    }

    public void registerPhase2() {
        this.flagManager.registerPhase2();
    }

    public boolean areCosmeticsAllowedHere(Player player, Category category) {
        return this.allowedCosmeticsState(player, category) == CosmeticRegionState.ALLOWED;
    }

    public CosmeticRegionState allowedCosmeticsState(Player player, Category category) {
        if (this.flagManager == null) {
            return CosmeticRegionState.ALLOWED;
        }
        if (!this.flagManager.flagCheck(UCFlag.COSMETICS, player)) {
            return CosmeticRegionState.BLOCKED_ALL;
        }
        if (category != null && !this.categoryFlagCheck(player, category)) {
            return CosmeticRegionState.BLOCKED_CATEGORY;
        }
        return CosmeticRegionState.ALLOWED;
    }

    public boolean canAffectPlayersHere(Player player) {
        if (this.flagManager == null) {
            return true;
        }
        return this.flagManager.flagCheck(UCFlag.COSMETICS, player) && this.flagManager.flagCheck(UCFlag.AFFECT_PLAYERS, player);
    }

    public boolean areChestsAllowedHere(Player player) {
        if (this.flagManager == null) {
            return true;
        }
        return this.flagManager.flagCheck(UCFlag.TREASURE, player);
    }

    public void doCosmeticCheck(Player player, UltraCosmetics uc) {
        if (this.flagManager == null) {
            return;
        }
        if (!this.flagManager.flagCheck(UCFlag.COSMETICS, player) && uc.getPlayerManager().getUltraPlayer(player).clear()) {
            player.sendMessage(MessageManager.getMessage("Region-Disabled"));
            return;
        }
        Set<Category> blockedCategories = this.flagManager.categoryFlagCheck(player);
        if (blockedCategories == null) {
            return;
        }
        for (Category category : blockedCategories) {
            if (!blockedCategories.contains((Object)category) || !uc.getPlayerManager().getUltraPlayer(player).removeCosmetic(category)) continue;
            player.sendMessage(MessageManager.getMessage("Region-Disabled-Category").replace("%category%", ChatColor.stripColor((String)MessageManager.getMessage("Menu." + category.getMessagesName() + ".Title"))));
        }
    }

    protected boolean categoryFlagCheck(Player player, Category category) {
        Set<Category> categories = this.flagManager.categoryFlagCheck(player);
        return categories == null || !categories.contains((Object)category);
    }
}

