/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.worldguard;

import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.worldguard.CosmeticFlagHandler;
import be.isach.ultracosmetics.worldguard.IFlagManager;
import be.isach.ultracosmetics.worldguard.UCFlag;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.EnumFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.SetFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.Set;
import org.bukkit.entity.Player;

public class FlagManager
implements IFlagManager {
    protected static final SetFlag<Category> CATEGORY_FLAG = new SetFlag("uc-blocked-categories", (Flag)new EnumFlag(null, Category.class));
    private static final Factory FACTORY = new Factory();

    @Override
    public void register() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        for (UCFlag flag : UCFlag.values()) {
            registry.register((Flag)flag.getFlag());
        }
        registry.register(CATEGORY_FLAG);
    }

    @Override
    public void registerPhase2() {
        WorldGuard.getInstance().getPlatform().getSessionManager().registerHandler((Handler.Factory)FACTORY, null);
    }

    @Override
    public boolean flagCheck(UCFlag flag, Player bukkitPlayer) {
        LocalPlayer player = WorldGuardPlugin.inst().wrapPlayer(bukkitPlayer);
        RegionContainer rc = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = rc.createQuery();
        return query.testState(player.getLocation(), player, new StateFlag[]{flag.getFlag()});
    }

    @Override
    public Set<Category> categoryFlagCheck(Player bukkitPlayer) {
        LocalPlayer player = WorldGuardPlugin.inst().wrapPlayer(bukkitPlayer);
        RegionContainer rc = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = rc.createQuery();
        return (Set)query.queryValue(player.getLocation(), player, CATEGORY_FLAG);
    }

    public static class Factory
    extends Handler.Factory<CosmeticFlagHandler> {
        public CosmeticFlagHandler create(Session session) {
            return new CosmeticFlagHandler(session, UCFlag.COSMETICS.getFlag(), CATEGORY_FLAG);
        }
    }
}

