/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.worldguard;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.BukkitPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.SetFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CosmeticFlagHandler
extends Handler {
    private static final Set<Category> ALL_CATEGORIES = new HashSet<Category>();
    private final UltraPlayerManager pm = UltraCosmeticsData.get().getPlugin().getPlayerManager();
    private final StateFlag cosmeticsFlag;
    private final SetFlag<Category> categoryFlag;
    private Set<Category> lastCategoryFlagValue = null;

    protected CosmeticFlagHandler(Session session, StateFlag cosmeticsFlag, SetFlag<Category> categoryFlag) {
        super(session);
        this.cosmeticsFlag = cosmeticsFlag;
        this.categoryFlag = categoryFlag;
    }

    public boolean onCrossBoundary(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        if (entered.isEmpty() && exited.isEmpty() && from.getExtent().equals(to.getExtent())) {
            return true;
        }
        if (Bukkit.getPlayer((UUID)player.getUniqueId()) == null) {
            return true;
        }
        Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
        StateFlag.State currentValue = toSet.queryState((RegionAssociable)player, new StateFlag[]{this.cosmeticsFlag});
        if (currentValue == StateFlag.State.DENY) {
            if (this.pm.getUltraPlayer(bukkitPlayer).clear()) {
                bukkitPlayer.sendMessage(MessageManager.getMessage("Region-Disabled"));
            }
            this.lastCategoryFlagValue = ALL_CATEGORIES;
            return true;
        }
        Set categoryValue = (Set)toSet.queryValue((RegionAssociable)player, this.categoryFlag);
        Set<Category> needsUpdating = this.compareSets(categoryValue, this.lastCategoryFlagValue);
        if (needsUpdating.size() > 0) {
            UltraPlayer up = this.pm.getUltraPlayer(bukkitPlayer);
            for (Category cat : needsUpdating) {
                if (!up.removeCosmetic(cat)) continue;
                bukkitPlayer.sendMessage(MessageManager.getMessage("Region-Disabled-Category").replace("%category%", cat.getMessagesName()));
            }
        }
        this.lastCategoryFlagValue = categoryValue;
        return true;
    }

    private Set<Category> compareSets(Set<Category> currentSet, Set<Category> lastSet) {
        HashSet<Category> newValues = new HashSet<Category>();
        if (currentSet == null) {
            return newValues;
        }
        if (lastSet == null) {
            return currentSet;
        }
        newValues.addAll(currentSet);
        newValues.removeAll(lastSet);
        return newValues;
    }

    static {
        for (Category cat : Category.values()) {
            ALL_CATEGORIES.add(cat);
        }
    }
}

