/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.version;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.pets.APlayerFollower;
import be.isach.ultracosmetics.cosmetics.pets.Pet;
import be.isach.ultracosmetics.util.ReflectionUtils;
import be.isach.ultracosmetics.util.ServerVersion;
import be.isach.ultracosmetics.version.APIAncientUtil;
import be.isach.ultracosmetics.version.IAncientUtil;
import be.isach.ultracosmetics.version.IAnvilWrapper;
import be.isach.ultracosmetics.version.IEntityUtil;
import be.isach.ultracosmetics.version.IFireworkFactory;
import be.isach.ultracosmetics.version.IModule;
import be.isach.ultracosmetics.version.IMorphs;
import be.isach.ultracosmetics.version.IPets;
import be.isach.ultracosmetics.version.Mounts;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class VersionManager {
    public static boolean IS_VERSION_1_13 = UltraCosmeticsData.get().getServerVersion().isAtLeast(ServerVersion.v1_13);
    public static final String PACKAGE = "be.isach.ultracosmetics";
    private static final Map<UUID, Integer> WORLD_MIN_HEIGHTS = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> WORLD_MAX_HEIGHTS = new HashMap<UUID, Integer>();
    private final ServerVersion serverVersion;
    private IModule module;
    private IEntityUtil entityUtil;
    private IAncientUtil ancientUtil;
    private IFireworkFactory fireworkFactory;
    private Mounts mounts;
    private IPets pets;
    private IMorphs morphs;
    private Constructor<? extends APlayerFollower> playerFollowerConstructor;

    public VersionManager(ServerVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    public void load() throws ReflectiveOperationException {
        this.ancientUtil = this.serverVersion == ServerVersion.v1_8 ? (IAncientUtil)this.loadModule("AncientUtil") : new APIAncientUtil();
        this.module = (IModule)this.loadModule("Module");
        this.entityUtil = (IEntityUtil)this.loadModule("EntityUtil");
        this.mounts = new Mounts();
        this.fireworkFactory = (IFireworkFactory)this.loadModule("FireworkFactory");
        this.pets = (IPets)this.loadModule("Pets");
        this.morphs = (IMorphs)this.loadModule("Morphs");
        this.playerFollowerConstructor = ReflectionUtils.getConstructor(Class.forName("be.isach.ultracosmetics." + this.serverVersion.getNmsVersion() + ".pets.PlayerFollower"), Pet.class, Player.class);
        this.playerFollowerConstructor.setAccessible(true);
    }

    private <T> T loadModule(String name) throws ReflectiveOperationException {
        return (T)ReflectionUtils.instantiateObject(Class.forName("be.isach.ultracosmetics." + this.serverVersion.getNmsVersion() + "." + name), new Object[0]);
    }

    public IEntityUtil getEntityUtil() {
        return this.entityUtil;
    }

    public IAncientUtil getAncientUtil() {
        return this.ancientUtil;
    }

    public IFireworkFactory getFireworkFactory() {
        return this.fireworkFactory;
    }

    public Mounts getMounts() {
        return this.mounts;
    }

    public APlayerFollower newPlayerFollower(Pet pet, Player player) {
        try {
            return this.playerFollowerConstructor.newInstance(pet, player);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IPets getPets() {
        return this.pets;
    }

    public IMorphs getMorphs() {
        return this.morphs;
    }

    public IModule getModule() {
        return this.module;
    }

    public IAnvilWrapper getAnvilWrapper() {
        try {
            return (IAnvilWrapper)this.loadModule("AnvilWrapper");
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getWorldMinHeight(World world) {
        return WORLD_MIN_HEIGHTS.computeIfAbsent(world.getUID(), w -> {
            try {
                return world.getMinHeight();
            }
            catch (NoSuchMethodError ex) {
                return 0;
            }
        });
    }

    public int getWorldMaxHeight(World world) {
        return WORLD_MAX_HEIGHTS.computeIfAbsent(world.getUID(), w -> {
            try {
                return world.getMaxHeight();
            }
            catch (NoSuchMethodError ex) {
                return 255;
            }
        });
    }
}

