/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.version;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.mounts.Mount;
import be.isach.ultracosmetics.util.ServerVersion;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;

public class Mounts {
    private final boolean is18 = UltraCosmeticsData.get().getServerVersion() == ServerVersion.v1_8;
    private final String packageName = "be.isach.ultracosmetics.cosmetics.mounts." + (this.is18 ? "pretend" : "abstract") + "horse";

    public Class<? extends Mount> getHorrorClass() {
        return this.getMountClass("InfernalHorror");
    }

    public Class<? extends Mount> getWalkingDeadClass() {
        return this.getMountClass("WalkingDead");
    }

    public Class<? extends Mount> getRudolphClass() {
        return this.getMountClass("Rudolph");
    }

    private Class<? extends Mount> getMountClass(String name) {
        try {
            return Class.forName(this.packageName + ".Mount" + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public EntityType getHorrorType() {
        return this.is18 ? EntityType.HORSE : EntityType.SKELETON_HORSE;
    }

    public EntityType getWalkingDeadType() {
        return this.is18 ? EntityType.HORSE : EntityType.ZOMBIE_HORSE;
    }

    public EntityType getRudolphType() {
        return this.is18 ? EntityType.HORSE : EntityType.MULE;
    }

    public Class<? extends LivingEntity> getAbstractHorseClass() {
        return this.is18 ? Horse.class : AbstractHorse.class;
    }

    public boolean isAbstractHorse(EntityType type) {
        return this.getAbstractHorseClass().isAssignableFrom(type.getEntityClass());
    }
}

