/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.v1_8_R3.customentities;

import be.isach.ultracosmetics.v1_8_R3.customentities.CustomGuardian;
import be.isach.ultracosmetics.v1_8_R3.customentities.CustomSlime;
import be.isach.ultracosmetics.v1_8_R3.customentities.Pumpling;
import be.isach.ultracosmetics.v1_8_R3.customentities.RideableSpider;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityInsentient;
import net.minecraft.server.v1_8_R3.EntityTypes;
import org.bukkit.entity.EntityType;

public enum CustomEntities {
    PUMPLING("Pumpling", EntityType.ZOMBIE, Pumpling.class, Pumpling.class),
    SLIME("CustomSlime", EntityType.SLIME, CustomSlime.class, CustomSlime.class),
    RIDEABLE_SPIDER("RideableSpider", EntityType.SPIDER, RideableSpider.class, RideableSpider.class),
    CUSTOM_GUARDIAN("CustomGuardian", EntityType.GHAST, CustomGuardian.class, CustomGuardian.class);

    private String name;
    private short id;
    private Class<? extends EntityInsentient> nmsClass;
    private Class<? extends EntityInsentient> customClass;
    private static final Set<Entity> customEntities;

    private CustomEntities(String name, EntityType entityType, Class<? extends EntityInsentient> nmsClass, Class<? extends EntityInsentient> customClass) {
        this.name = name;
        this.id = entityType.getTypeId();
        this.nmsClass = nmsClass;
        this.customClass = customClass;
    }

    public static void registerEntities() {
        for (CustomEntities entity : CustomEntities.values()) {
            CustomEntities.a(entity.customClass, entity.name, entity.id);
        }
    }

    public static void unregisterEntities() {
        for (CustomEntities entity : CustomEntities.values()) {
            try {
                CustomEntities.getEntityTypesMap("d").remove(entity.customClass);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                CustomEntities.getEntityTypesMap("f").remove(entity.customClass);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (CustomEntities entity : CustomEntities.values()) {
            try {
                CustomEntities.a(entity.nmsClass, entity.name, entity.id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Map<Object, Object> getEntityTypesMap(String f) throws Exception {
        Field field = EntityTypes.class.getDeclaredField(f);
        field.setAccessible(true);
        return (Map)field.get(null);
    }

    private static void a(Class paramClass, String paramString, int paramInt) {
        try {
            CustomEntities.getEntityTypesMap("c").put(paramString, paramClass);
            CustomEntities.getEntityTypesMap("d").put(paramClass, paramString);
            CustomEntities.getEntityTypesMap("e").put(paramInt, paramClass);
            CustomEntities.getEntityTypesMap("f").put(paramClass, paramInt);
            CustomEntities.getEntityTypesMap("g").put(paramString, paramInt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addCustomEntity(Entity entity) {
        customEntities.add(entity);
    }

    public static boolean isCustomEntity(Entity entity) {
        return customEntities.contains(entity);
    }

    public static void removeCustomEntity(Entity entity) {
        customEntities.remove(entity);
    }

    static {
        customEntities = new HashSet<Entity>();
    }
}

