/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.v1_8_R3;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.treasurechests.TreasureChestDesign;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Particles;
import be.isach.ultracosmetics.v1_8_R3.pathfinders.CustomPathFinderGoalPanic;
import be.isach.ultracosmetics.version.IEntityUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityArmorStand;
import net.minecraft.server.v1_8_R3.EntityBoat;
import net.minecraft.server.v1_8_R3.EntityCreature;
import net.minecraft.server.v1_8_R3.EntityEnderDragon;
import net.minecraft.server.v1_8_R3.EntityInsentient;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_8_R3.PathEntity;
import net.minecraft.server.v1_8_R3.PathfinderGoal;
import net.minecraft.server.v1_8_R3.PathfinderGoalSelector;
import net.minecraft.server.v1_8_R3.TileEntity;
import net.minecraft.server.v1_8_R3.Vector3f;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftWither;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_8_R3.util.UnsafeList;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wither;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityUtil
implements IEntityUtil {
    private final Random r = new Random();
    private final Map<Player, Set<EntityArmorStand>> fakeArmorStandsMap = new HashMap<Player, Set<EntityArmorStand>>();
    private final Map<Player, Set<org.bukkit.entity.Entity>> cooldownJumpMap = new HashMap<Player, Set<org.bukkit.entity.Entity>>();

    @Override
    public void resetWitherSize(Wither wither) {
        ((CraftWither)wither).getHandle().r(600);
    }

    @Override
    public void sendBlizzard(Player player, Location loc, Function<org.bukkit.entity.Entity, Boolean> canAffectFunc, Vector v) {
        Set fakeArmorStands = this.fakeArmorStandsMap.computeIfAbsent(player, k -> new HashSet());
        Set cooldownJump = this.cooldownJumpMap.computeIfAbsent(player, k -> new HashSet());
        EntityArmorStand as = new EntityArmorStand((World)((CraftWorld)player.getWorld()).getHandle());
        as.setInvisible(true);
        as.setSmall(true);
        as.setGravity(false);
        as.setArms(true);
        as.setHeadPose(new Vector3f((float)this.r.nextInt(360), (float)this.r.nextInt(360), (float)this.r.nextInt(360)));
        as.setLocation(loc.getX() + MathUtils.randomDouble(-1.5, 1.5), loc.getY() + MathUtils.randomDouble(0.0, 0.5) - 0.75, loc.getZ() + MathUtils.randomDouble(-1.5, 1.5), 0.0f, 0.0f);
        fakeArmorStands.add(as);
        for (Player players : player.getWorld().getPlayers()) {
            this.sendPacket(players, (Packet<?>)new PacketPlayOutSpawnEntityLiving((EntityLiving)as));
            this.sendPacket(players, (Packet<?>)new PacketPlayOutEntityEquipment(as.getId(), 4, CraftItemStack.asNMSCopy((ItemStack)new ItemStack(Material.PACKED_ICE))));
        }
        Particles.CLOUD.display(loc.clone().add(MathUtils.randomDouble(-1.5, 1.5), MathUtils.randomDouble(0.0, 0.5) - 0.75, MathUtils.randomDouble(-1.5, 1.5)), 2, 0.4f);
        Bukkit.getScheduler().runTaskLater((Plugin)UltraCosmeticsData.get().getPlugin(), () -> {
            for (Player pl : player.getWorld().getPlayers()) {
                if (as == null) continue;
                this.sendPacket(pl, (Packet<?>)new PacketPlayOutEntityDestroy(new int[]{as.getId()}));
            }
            fakeArmorStands.remove(as);
        }, 20L);
        for (org.bukkit.entity.Entity ent : as.getBukkitEntity().getNearbyEntities(0.5, 0.5, 0.5)) {
            if (cooldownJump.contains(ent) || ent == player || !canAffectFunc.apply(ent).booleanValue()) continue;
            MathUtils.applyVelocity(ent, new Vector(0, 1, 0).add(v));
            cooldownJump.add(ent);
            Bukkit.getScheduler().runTaskLater((Plugin)UltraCosmeticsData.get().getPlugin(), () -> cooldownJump.remove(ent), 20L);
        }
    }

    @Override
    public void clearBlizzard(Player player) {
        if (!this.fakeArmorStandsMap.containsKey(player)) {
            return;
        }
        for (EntityArmorStand as : this.fakeArmorStandsMap.get(player)) {
            for (Player pl : player.getWorld().getPlayers()) {
                this.sendPacket(pl, (Packet<?>)new PacketPlayOutEntityDestroy(new int[]{as.getId()}));
            }
        }
        this.fakeArmorStandsMap.remove(player);
        this.cooldownJumpMap.remove(player);
    }

    @Override
    public void clearPathfinders(org.bukkit.entity.Entity bukkitEntity) {
        EntityInsentient entity = (EntityInsentient)((CraftEntity)bukkitEntity).getHandle();
        try {
            Field bField = PathfinderGoalSelector.class.getDeclaredField("b");
            bField.setAccessible(true);
            Field cField = PathfinderGoalSelector.class.getDeclaredField("c");
            cField.setAccessible(true);
            bField.set(entity.goalSelector, new UnsafeList());
            bField.set(entity.targetSelector, new UnsafeList());
            cField.set(entity.goalSelector, new UnsafeList());
            cField.set(entity.targetSelector, new UnsafeList());
        }
        catch (ReflectiveOperationException exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public void makePanic(org.bukkit.entity.Entity entity) {
        EntityInsentient insentient = (EntityInsentient)((CraftEntity)entity).getHandle();
        insentient.goalSelector.a(3, (PathfinderGoal)new CustomPathFinderGoalPanic((EntityCreature)insentient, 0.4));
    }

    @Override
    public void sendDestroyPacket(Player player, org.bukkit.entity.Entity entity) {
        this.sendPacket(player, (Packet<?>)new PacketPlayOutEntityDestroy(new int[]{((CraftEntity)entity).getHandle().getId()}));
    }

    @Override
    public void move(Creature creature, Location loc) {
        EntityCreature ec = ((CraftCreature)creature).getHandle();
        this.setStepHeight((org.bukkit.entity.Entity)creature);
        if (loc == null) {
            return;
        }
        ec.getNavigation().a(loc.getX(), loc.getY(), loc.getZ(), 2.0);
    }

    @Override
    public void moveDragon(Player player, Vector vector, org.bukkit.entity.Entity entity) {
        EntityEnderDragon ec = ((CraftEnderDragon)entity).getHandle();
        ec.hurtTicks = -1;
        ec.getBukkitEntity().setVelocity(vector);
        ec.pitch = player.getLocation().getPitch();
        ec.yaw = player.getLocation().getYaw() - 180.0f;
    }

    @Override
    public void setStepHeight(org.bukkit.entity.Entity entity) {
        ((CraftEntity)entity).getHandle().S = 1.0f;
    }

    @Override
    public void moveShip(Player player, org.bukkit.entity.Entity entity, Vector vector) {
        EntityBoat ec = ((CraftBoat)entity).getHandle();
        ec.getBukkitEntity().setVelocity(vector);
        ec.pitch = player.getLocation().getPitch();
        ec.yaw = player.getLocation().getYaw() - 180.0f;
    }

    @Override
    public void playChestAnimation(Block b2, boolean open, TreasureChestDesign design) {
        Location location = b2.getLocation();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        TileEntity tileChest = world.getTileEntity(position);
        world.playBlockAction(position, tileChest.w(), 1, open ? 1 : 0);
    }

    @Override
    public void follow(org.bukkit.entity.Entity toFollow, org.bukkit.entity.Entity follower) {
        Entity pett = ((CraftEntity)follower).getHandle();
        ((EntityInsentient)pett).getNavigation().a(2.0f);
        Entity petf = ((CraftEntity)follower).getHandle();
        Location targetLocation = toFollow.getLocation();
        PathEntity path = ((EntityInsentient)petf).getNavigation().a(targetLocation.getX() + 1.0, targetLocation.getY(), targetLocation.getZ() + 1.0);
        if (path != null) {
            ((EntityInsentient)petf).getNavigation().a(path, 1.05);
            ((EntityInsentient)petf).getNavigation().a(1.05);
        }
    }

    @Override
    public void sendTeleportPacket(Player player, org.bukkit.entity.Entity entity) {
        this.sendPacket(player, (Packet<?>)new PacketPlayOutEntityTeleport(((CraftEntity)entity).getHandle()));
    }

    private void sendPacket(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
    }
}

