/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.v1_18_R2.customentities;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.v1_18_R2.EntityBase;
import be.isach.ultracosmetics.v1_18_R2.customentities.CustomGuardian;
import be.isach.ultracosmetics.v1_18_R2.customentities.CustomSlime;
import be.isach.ultracosmetics.v1_18_R2.customentities.Pumpling;
import be.isach.ultracosmetics.v1_18_R2.customentities.RideableSpider;
import be.isach.ultracosmetics.v1_18_R2.nms.EntityWrapper;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.phys.Vec3D;

public class CustomEntities {
    private static final Set<Entity> customEntities = new HashSet<Entity>();

    public static void registerEntities() {
        Map types = DataConverterRegistry.a().getSchema(DataFixUtils.makeKey((int)SharedConstants.b().getWorldVersion())).findChoiceType(DataConverterTypes.q).types();
        boolean isRealRegistry = IRegistry.W.getClass().equals(RegistryBlocks.class);
        if (isRealRegistry) {
            CustomEntities.unfreezeRegistry();
        } else {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write("Entity registry is not vanilla, skipping unfreeze and refreeze");
        }
        CustomEntities.registerEntity("zombie", Pumpling::new, types);
        CustomEntities.registerEntity("slime", CustomSlime::new, types);
        CustomEntities.registerEntity("spider", RideableSpider::new, types);
        CustomEntities.registerEntity("guardian", CustomGuardian::new, types);
        if (isRealRegistry) {
            IRegistry.W.j();
        }
    }

    private static void unfreezeRegistry() {
        Class<RegistryMaterials> registryClass = RegistryMaterials.class;
        try {
            Field intrusiveHolderCache = registryClass.getDeclaredField("bN");
            intrusiveHolderCache.setAccessible(true);
            intrusiveHolderCache.set(IRegistry.W, new IdentityHashMap());
            Field frozen = registryClass.getDeclaredField("bL");
            frozen.setAccessible(true);
            frozen.set(IRegistry.W, false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return;
        }
    }

    private static void registerEntity(String type, EntityTypes.b customMob, Map<String, Type<?>> types) {
        String customName = "minecraft:ultracosmetics_" + type;
        MinecraftKey key = new MinecraftKey(customName);
        if (IRegistry.W.c(key)) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Skipping registration of " + customName + " because it is already registered.");
            return;
        }
        types.put(customName, types.get("minecraft:" + type));
        EntityTypes.Builder a = EntityTypes.Builder.a((EntityTypes.b)customMob, (EnumCreatureType)EnumCreatureType.c);
        IRegistry.a((IRegistry)IRegistry.W, (String)customName, (Object)a.a(customName));
    }

    public static void ride(float sideMot, float forMot, EntityHuman passenger, EntityInsentient mob) {
        if (!(mob instanceof EntityBase)) {
            throw new IllegalArgumentException("The entity parameter should implement EntityBase");
        }
        EntityBase entityBase = (EntityBase)mob;
        EntityInsentient entity = mob;
        EntityWrapper wEntity = new EntityWrapper((EntityLiving)mob);
        EntityWrapper wPassenger = new EntityWrapper((EntityLiving)passenger);
        if (passenger == null) {
            wEntity.setStepHeight(0.5f);
            wEntity.setJumpMovementFactor(0.02f);
            entityBase.travel_(sideMot, forMot);
            return;
        }
        entity.w = passenger.dn() % 360.0f;
        entity.o(entity.w);
        entity.p(passenger.do() * 0.5f % 360.0f);
        wEntity.setRenderYawOffset(entity.dn());
        wEntity.setRotationYawHead(entity.dn());
        sideMot = wPassenger.getMoveStrafing() * 0.25f;
        forMot = wPassenger.getMoveForward() * 0.5f;
        if (forMot <= 0.0f) {
            forMot *= 0.25f;
        }
        wEntity.setJumping(wPassenger.isJumping());
        if (wPassenger.isJumping() && entity.aw()) {
            Vec3D v = entity.da();
            Vec3D v2 = new Vec3D(v.a(), 0.4, v.c());
            entity.g(v2);
        }
        wEntity.setStepHeight(1.0f);
        wEntity.setJumpMovementFactor(wEntity.getMoveSpeed() * 0.1f);
        wEntity.setRotationYawHead(entity.dn());
        entityBase.travel_(sideMot, forMot);
        wEntity.setPrevLimbSwingAmount(wEntity.getLimbSwingAmount());
        double dx = entity.dc() - entity.t;
        double dz = entity.di() - entity.v;
        float f4 = MathHelper.c((float)((float)(dx * dx + dz * dz))) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        wEntity.setLimbSwingAmount(wEntity.getLimbSwingAmount() + (f4 - wEntity.getLimbSwingAmount()) * 0.4f);
        wEntity.setLimbSwing(wEntity.getLimbSwing() + wEntity.getLimbSwingAmount());
    }

    public static void addCustomEntity(Entity entity) {
        customEntities.add(entity);
    }

    public static boolean isCustomEntity(Entity entity) {
        return customEntities.contains(entity);
    }

    public static void removeCustomEntity(Entity entity) {
        customEntities.remove(entity);
    }
}

