/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.v1_12_R1.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.EntitySpawningManager;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.v1_12_R1.FireworkFactory;
import be.isach.ultracosmetics.v1_12_R1.customentities.CustomGuardian;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_12_R1.World;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MorphElderGuardian
extends Morph
implements Updatable {
    public static List<net.minecraft.server.v1_12_R1.Entity> customEntities = new ArrayList<net.minecraft.server.v1_12_R1.Entity>();
    private boolean cooldown;
    private CustomGuardian customGuardian;

    public MorphElderGuardian(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (!(event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK || this.cooldown || event.getPlayer() != this.getPlayer())) {
            this.shootLaser();
            this.cooldown = true;
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getUltraCosmetics(), () -> {
                this.cooldown = false;
            }, 80L);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (((CraftEntity)event.getDamager()).getHandle() == this.customGuardian && event.getEntity() == this.getPlayer()) {
            event.setCancelled(true);
        }
    }

    private void shootLaser() {
        if (this.customGuardian == null) {
            return;
        }
        Location FROM = this.customGuardian.getBukkitEntity().getLocation();
        Location TO = FROM.clone().add(this.getPlayer().getLocation().getDirection().multiply(10));
        ArmorStand armorStand = (ArmorStand)this.getPlayer().getWorld().spawn(TO, ArmorStand.class);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setSmall(true);
        this.customGuardian.target(armorStand);
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
            FireworkEffect.Builder builder = FireworkEffect.builder();
            FireworkEffect effect = builder.flicker(false).trail(false).with(FireworkEffect.Type.BALL_LARGE).withColor(Color.TEAL).withFade(Color.TEAL).build();
            new FireworkFactory().spawn(TO, effect, new Player[0]);
            Vector vector = TO.toVector().subtract(FROM.toVector());
            Location current = FROM.clone();
            for (int i = 0; i < 10; ++i) {
                for (Entity entity : current.getWorld().getNearbyEntities(current, 4.5, 4.5, 4.5)) {
                    if (!(entity instanceof LivingEntity) || entity == this.getPlayer()) continue;
                    MathUtils.applyVelocity(entity, new Vector(0.0, 0.5, 0.0));
                }
                current.add(vector);
            }
            armorStand.remove();
            this.customGuardian.target(null);
        }, 25L);
    }

    @Override
    public void onClear() {
        if (this.customGuardian != null) {
            this.customGuardian.dead = true;
        }
        customEntities.remove((Object)this.customGuardian);
    }

    @Override
    protected void onEquip() {
        super.onEquip();
        WorldServer world = ((CraftWorld)this.getPlayer().getWorld()).getHandle();
        this.customGuardian = new CustomGuardian((World)world);
        customEntities.add((net.minecraft.server.v1_12_R1.Entity)this.customGuardian);
        this.customGuardian.check();
        Location location = this.getPlayer().getLocation();
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        this.customGuardian.setLocation(x, y, z, 0.0f, 0.0f);
        EntitySpawningManager.setBypass(true);
        world.addEntity((net.minecraft.server.v1_12_R1.Entity)this.customGuardian);
        EntitySpawningManager.setBypass(false);
        this.getPlayer().addPassenger((Entity)this.customGuardian.getBukkitEntity());
        this.customGuardian.setInvisible(true);
    }

    @Override
    public void onUpdate() {
        if (this.getOwner() == null || this.getPlayer() == null) {
            this.cancel();
            return;
        }
        if (this.customGuardian == null || !this.customGuardian.isAlive()) {
            this.getOwner().removeCosmetic(Category.MORPHS);
            this.cancel();
        }
    }
}

