/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.v1_12_R1.customentities;

import be.isach.ultracosmetics.v1_12_R1.EntityBase;
import be.isach.ultracosmetics.v1_12_R1.customentities.CustomGuardian;
import be.isach.ultracosmetics.v1_12_R1.customentities.CustomSlime;
import be.isach.ultracosmetics.v1_12_R1.customentities.Pumpling;
import be.isach.ultracosmetics.v1_12_R1.customentities.RideableSpider;
import be.isach.ultracosmetics.v1_12_R1.nms.EntityWrapper;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityGuardian;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityInsentient;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.EntitySlime;
import net.minecraft.server.v1_12_R1.EntitySpider;
import net.minecraft.server.v1_12_R1.EntityTypes;
import net.minecraft.server.v1_12_R1.EntityZombie;
import net.minecraft.server.v1_12_R1.MathHelper;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import net.minecraft.server.v1_12_R1.RegistryID;
import net.minecraft.server.v1_12_R1.RegistryMaterials;
import org.bukkit.entity.EntityType;

public enum CustomEntities {
    PUMPLING("Pumpling", EntityType.ZOMBIE, EntityZombie.class, Pumpling.class),
    SLIME("CustomSlime", EntityType.SLIME, EntitySlime.class, CustomSlime.class),
    RIDEABLE_SPIDER("RideableSpider", EntityType.SPIDER, EntitySpider.class, RideableSpider.class),
    CUSTOM_GUARDIAN("CustomGuardian", EntityType.GHAST, EntityGuardian.class, CustomGuardian.class);

    private static final Set<Entity> customEntities;
    private final short id;
    private final MinecraftKey minecraftKey;
    private final Class<? extends EntityInsentient> nmsClass;
    private final Class<? extends EntityInsentient> customClass;

    private CustomEntities(String name, EntityType entityType, Class<? extends EntityInsentient> nmsClass, Class<? extends EntityInsentient> customClass) {
        this.id = entityType.getTypeId();
        this.minecraftKey = new MinecraftKey(name);
        this.nmsClass = nmsClass;
        this.customClass = customClass;
    }

    public static void registerEntities() {
        BiomeBase biomeBase;
        for (CustomEntities entity : CustomEntities.values()) {
            try {
                RegistryID registryID = (RegistryID)CustomEntities.getPrivateField(RegistryMaterials.class, EntityTypes.b, "a");
                Object[] idToClassMap = (Object[])CustomEntities.getPrivateField(RegistryID.class, registryID, "d");
                Object oldValue = idToClassMap[entity.id];
                registryID.a(entity.customClass, (int)entity.id);
                idToClassMap[entity.id] = oldValue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator iterator = BiomeBase.i.iterator();
        while (iterator.hasNext() && (biomeBase = (BiomeBase)iterator.next()) != null) {
            for (String field : new String[]{"t", "u", "v", "w"}) {
                try {
                    Field list = BiomeBase.class.getDeclaredField(field);
                    list.setAccessible(true);
                    List mobList = (List)list.get(biomeBase);
                    for (BiomeBase.BiomeMeta meta : mobList) {
                        for (CustomEntities entity : CustomEntities.values()) {
                            if (!entity.nmsClass.equals(meta.b)) continue;
                            meta.b = entity.customClass;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void unregisterEntities() {
        for (CustomEntities entity : CustomEntities.values()) {
            try {
                EntityTypes.b.a((int)entity.id, (Object)entity.minecraftKey, entity.nmsClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Object getPrivateField(Class<?> clazz, Object handle, String fieldName) throws Exception {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(handle);
    }

    public static void ride(float sideMot, float forMot, EntityHuman passenger, EntityInsentient entity) {
        if (!(entity instanceof EntityBase)) {
            throw new IllegalArgumentException("The entity field should implements EntityBase");
        }
        EntityBase entityBase = (EntityBase)entity;
        EntityWrapper wEntity = new EntityWrapper((EntityLiving)entity);
        EntityWrapper wPassenger = new EntityWrapper((EntityLiving)passenger);
        if (passenger != null) {
            entity.lastYaw = entity.yaw = passenger.yaw % 360.0f;
            entity.pitch = passenger.pitch * 0.5f % 360.0f;
            wEntity.setRenderYawOffset(entity.yaw);
            wEntity.setRotationYawHead(entity.yaw);
            sideMot = wPassenger.getMoveStrafing() * 0.25f;
            forMot = wPassenger.getMoveForward() * 0.5f;
            if (forMot <= 0.0f) {
                forMot *= 0.25f;
            }
            wEntity.setJumping(wPassenger.isJumping());
            if (wPassenger.isJumping() && entity.onGround) {
                entity.motY = 0.4;
                float f2 = MathHelper.sin((float)(entity.yaw * ((float)Math.PI / 180)));
                float f3 = MathHelper.cos((float)(entity.yaw * ((float)Math.PI / 180)));
                entity.motX += (double)(-0.4f * f2);
                entity.motZ += (double)(0.4f * f3);
            }
            wEntity.setStepHeight(1.0f);
            wEntity.setJumpMovementFactor(wEntity.getMoveSpeed() * 0.1f);
            wEntity.setRotationYawHead(entity.yaw);
            entityBase.g_(sideMot, forMot);
            wEntity.setPrevLimbSwingAmount(wEntity.getLimbSwingAmount());
            double dx = entity.locX - entity.lastX;
            double dz = entity.locZ - entity.lastZ;
            float f4 = MathHelper.sqrt((double)(dx * dx + dz * dz)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            wEntity.setLimbSwingAmount(wEntity.getLimbSwingAmount() + (f4 - wEntity.getLimbSwingAmount()) * 0.4f);
            wEntity.setLimbSwing(wEntity.getLimbSwing() + wEntity.getLimbSwingAmount());
        } else {
            wEntity.setStepHeight(0.5f);
            wEntity.setJumpMovementFactor(0.02f);
            entityBase.g_(sideMot, forMot);
        }
    }

    public static void addCustomEntity(Entity entity) {
        customEntities.add(entity);
    }

    public static boolean isCustomEntity(Entity entity) {
        return customEntities.contains(entity);
    }

    public static void removeCustomEntity(Entity entity) {
        customEntities.remove(entity);
    }

    static {
        customEntities = new HashSet<Entity>();
    }
}

