/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.v1_12_R1;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.treasurechests.TreasureChestDesign;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Particles;
import be.isach.ultracosmetics.v1_12_R1.pathfinders.CustomPathFinderGoalPanic;
import be.isach.ultracosmetics.version.IEntityUtil;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.EntityArmorStand;
import net.minecraft.server.v1_12_R1.EntityBoat;
import net.minecraft.server.v1_12_R1.EntityCreature;
import net.minecraft.server.v1_12_R1.EntityEnderDragon;
import net.minecraft.server.v1_12_R1.EntityInsentient;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.EnumItemSlot;
import net.minecraft.server.v1_12_R1.EnumMoveType;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_12_R1.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_12_R1.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_12_R1.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_12_R1.PathEntity;
import net.minecraft.server.v1_12_R1.PathfinderGoal;
import net.minecraft.server.v1_12_R1.PathfinderGoalSelector;
import net.minecraft.server.v1_12_R1.TileEntity;
import net.minecraft.server.v1_12_R1.Vector3f;
import net.minecraft.server.v1_12_R1.World;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftWither;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wither;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityUtil
implements IEntityUtil {
    private Random r = new Random();
    private Map<Player, Set<EntityArmorStand>> fakeArmorStandsMap = new HashMap<Player, Set<EntityArmorStand>>();
    private Map<Player, Set<Entity>> cooldownJumpMap = new HashMap<Player, Set<Entity>>();

    @Override
    public void resetWitherSize(Wither wither) {
        ((CraftWither)wither).getHandle().g(600);
    }

    @Override
    public void sendBlizzard(Player player, Location loc, Function<Entity, Boolean> canAffectFunc, Vector v) {
        Set fakeArmorStands = this.fakeArmorStandsMap.computeIfAbsent(player, k -> new HashSet());
        Set cooldownJump = this.cooldownJumpMap.computeIfAbsent(player, k -> new HashSet());
        EntityArmorStand as = new EntityArmorStand((World)((CraftWorld)player.getWorld()).getHandle());
        as.setInvisible(true);
        as.setSmall(true);
        as.setNoGravity(true);
        as.setArms(true);
        as.setHeadPose(new Vector3f((float)this.r.nextInt(360), (float)this.r.nextInt(360), (float)this.r.nextInt(360)));
        as.setLocation(loc.getX() + MathUtils.randomDouble(-1.5, 1.5), loc.getY() + MathUtils.randomDouble(0.0, 0.5) - 0.75, loc.getZ() + MathUtils.randomDouble(-1.5, 1.5), 0.0f, 0.0f);
        fakeArmorStands.add(as);
        for (Player players : player.getWorld().getPlayers()) {
            this.sendPacket(players, (Packet<?>)new PacketPlayOutSpawnEntityLiving((EntityLiving)as));
            this.sendPacket(players, (Packet<?>)new PacketPlayOutEntityEquipment(as.getId(), EnumItemSlot.HEAD, CraftItemStack.asNMSCopy((ItemStack)new ItemStack(Material.PACKED_ICE))));
        }
        Particles.CLOUD.display(loc.clone().add(MathUtils.randomDouble(-1.5, 1.5), MathUtils.randomDouble(0.0, 0.5) - 0.75, MathUtils.randomDouble(-1.5, 1.5)), 2, 0.4f);
        Bukkit.getScheduler().runTaskLater((Plugin)UltraCosmeticsData.get().getPlugin(), () -> {
            for (Player pl : player.getWorld().getPlayers()) {
                this.sendPacket(pl, (Packet<?>)new PacketPlayOutEntityDestroy(new int[]{as.getId()}));
            }
            fakeArmorStands.remove(as);
        }, 20L);
        as.getBukkitEntity().getNearbyEntities(0.5, 0.5, 0.5).stream().filter(ent -> !cooldownJump.contains(ent) && ent != player && (Boolean)canAffectFunc.apply((Entity)ent) != false).forEachOrdered(ent -> {
            MathUtils.applyVelocity(ent, new Vector(0, 1, 0).add(v));
            cooldownJump.add(ent);
            Bukkit.getScheduler().runTaskLater((Plugin)UltraCosmeticsData.get().getPlugin(), () -> cooldownJump.remove(ent), 20L);
        });
    }

    @Override
    public void clearBlizzard(Player player) {
        if (!this.fakeArmorStandsMap.containsKey(player)) {
            return;
        }
        for (EntityArmorStand as : this.fakeArmorStandsMap.get(player)) {
            if (as == null) continue;
            for (Player pl : player.getWorld().getPlayers()) {
                this.sendPacket(pl, (Packet<?>)new PacketPlayOutEntityDestroy(new int[]{as.getId()}));
            }
        }
        this.fakeArmorStandsMap.remove(player);
        this.cooldownJumpMap.remove(player);
    }

    @Override
    public void clearPathfinders(Entity entity) {
        net.minecraft.server.v1_12_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        try {
            Field bField = PathfinderGoalSelector.class.getDeclaredField("b");
            bField.setAccessible(true);
            Field cField = PathfinderGoalSelector.class.getDeclaredField("c");
            cField.setAccessible(true);
            bField.set(((EntityInsentient)nmsEntity).goalSelector, Sets.newLinkedHashSet());
            bField.set(((EntityInsentient)nmsEntity).targetSelector, Sets.newLinkedHashSet());
            cField.set(((EntityInsentient)nmsEntity).goalSelector, Sets.newLinkedHashSet());
            cField.set(((EntityInsentient)nmsEntity).targetSelector, Sets.newLinkedHashSet());
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public void makePanic(Entity entity) {
        EntityInsentient insentient = (EntityInsentient)((CraftEntity)entity).getHandle();
        insentient.goalSelector.a(3, (PathfinderGoal)new CustomPathFinderGoalPanic((EntityCreature)insentient));
    }

    @Override
    public void sendDestroyPacket(Player player, Entity entity) {
        this.sendPacket(player, (Packet<?>)new PacketPlayOutEntityDestroy(new int[]{((CraftEntity)entity).getHandle().getId()}));
    }

    @Override
    public void move(Creature creature, Location loc) {
        EntityCreature ec = ((CraftCreature)creature).getHandle();
        this.setStepHeight((Entity)creature);
        if (loc == null) {
            return;
        }
        ec.getNavigation().a(loc.getX(), loc.getY(), loc.getZ(), 2.0);
    }

    @Override
    public void moveDragon(Player player, Vector vector, Entity entity) {
        EntityEnderDragon ec = ((CraftEnderDragon)entity).getHandle();
        ec.hurtTicks = -1;
        ec.getBukkitEntity().setVelocity(vector);
        ec.pitch = player.getLocation().getPitch();
        ec.yaw = player.getLocation().getYaw() - 180.0f;
        Vector v = ec.getBukkitEntity().getLocation().getDirection();
        ec.move(EnumMoveType.SELF, -v.getX(), v.getY(), -v.getZ());
    }

    @Override
    public void setStepHeight(Entity entity) {
        ((CraftEntity)entity).getHandle().P = 1.0f;
    }

    @Override
    public void moveShip(Player player, Entity entity, Vector vector) {
        EntityBoat ec = ((CraftBoat)entity).getHandle();
        ec.getBukkitEntity().setVelocity(vector);
        ec.pitch = player.getLocation().getPitch();
        ec.yaw = player.getLocation().getYaw() - 180.0f;
        ec.move(EnumMoveType.SELF, 1.0, 0.0, 0.0);
    }

    @Override
    public void playChestAnimation(Block b, boolean open, TreasureChestDesign design) {
        Location location = b.getLocation();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        TileEntity tileChest = world.getTileEntity(position);
        world.playBlockAction(position, tileChest.getBlock(), 1, open ? 1 : 0);
    }

    @Override
    public void follow(Entity toFollow, Entity follower) {
        net.minecraft.server.v1_12_R1.Entity pett = ((CraftEntity)follower).getHandle();
        ((EntityInsentient)pett).getNavigation().a(2.0);
        net.minecraft.server.v1_12_R1.Entity petf = ((CraftEntity)follower).getHandle();
        Location targetLocation = toFollow.getLocation();
        PathEntity path = ((EntityInsentient)petf).getNavigation().a(targetLocation.getX() + 1.0, targetLocation.getY(), targetLocation.getZ() + 1.0);
        if (path != null) {
            ((EntityInsentient)petf).getNavigation().a(path, 1.05);
            ((EntityInsentient)petf).getNavigation().a(1.05);
        }
    }

    @Override
    public void sendTeleportPacket(Player player, Entity entity) {
        this.sendPacket(player, (Packet<?>)new PacketPlayOutEntityTeleport(((CraftEntity)entity).getHandle()));
    }

    private void sendPacket(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
    }
}

