/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.Version;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.util.SmartLogger;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateManager
extends BukkitRunnable {
    private static final String RESOURCE_URL = "https://api.spiget.org/v2/resources/10905/";
    private static final String VERSIONS_PREFIX = " Supported versions: ";
    private final Version currentVersion;
    private final UltraCosmetics ultraCosmetics;
    private boolean outdated = false;
    private Version spigotVersion;

    public UpdateManager(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        this.currentVersion = new Version(ultraCosmetics.getDescription().getVersion());
    }

    public void run() {
        String spigotVersionString = this.getLastVersion();
        if (spigotVersionString == null) {
            this.ultraCosmetics.getSmartLogger().write("Cannot update, unknown version");
            return;
        }
        this.spigotVersion = new Version(spigotVersionString);
        if (this.currentVersion.compareTo(this.spigotVersion) >= 0) {
            this.ultraCosmetics.getSmartLogger().write("No new version available.");
            return;
        }
        if (!this.checkMinecraftVersion()) {
            this.ultraCosmetics.getSmartLogger().write("A new version is available, but it doesn't support this server version.");
            return;
        }
        this.outdated = true;
        this.ultraCosmetics.getSmartLogger().write("New version available on Spigot: " + this.spigotVersion.get());
        if (!SettingsManager.getConfig().getBoolean("Auto-Update")) {
            return;
        }
        this.update();
    }

    public boolean update() {
        if (!this.download()) {
            this.ultraCosmetics.getSmartLogger().write("Failed to download update");
            return false;
        }
        this.outdated = false;
        this.ultraCosmetics.getSmartLogger().write("Successfully downloaded new version, restart server to apply update.");
        return true;
    }

    public String getLastVersion() {
        JsonObject jsonVersion = (JsonObject)this.apiRequest("versions/latest");
        if (jsonVersion == null) {
            return null;
        }
        String version = jsonVersion.get("name").toString();
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonElement apiRequest(String suffix) {
        InputStreamReader reader = null;
        try {
            JsonElement response;
            URL url = new URL(RESOURCE_URL + suffix);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", "UltraCosmetics Update Checker");
            InputStream inputStream = connection.getInputStream();
            reader = new InputStreamReader(inputStream);
            JsonElement jsonElement = response = new JsonParser().parse((Reader)reader);
            return jsonElement;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to check for an update on spigot.");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean download() {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            URL url = new URL("https://api.spiget.org/v2/resources/10905/download");
            in = new BufferedInputStream(url.openStream());
            fout = new FileOutputStream(new File(Bukkit.getUpdateFolderFile(), "UltraCosmetics-" + this.spigotVersion.get() + "-RELEASE.jar"));
            byte[] data = new byte[4096];
            while ((count = in.read(data, 0, 4096)) != -1) {
                fout.write(data, 0, count);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.ultraCosmetics.getLogger().log(Level.SEVERE, null, e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.ultraCosmetics.getLogger().log(Level.SEVERE, null, e);
                e.printStackTrace();
            }
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                this.ultraCosmetics.getLogger().log(Level.SEVERE, null, e);
                e.printStackTrace();
            }
        }
    }

    private boolean checkMinecraftVersion() {
        JsonObject update = (JsonObject)this.apiRequest("updates/latest");
        String description = new String(Base64.getDecoder().decode(update.get("description").getAsString()));
        String[] lines = description.split("\\<br\\>");
        String supportedVersionsLine = lines[lines.length - 1];
        if (!supportedVersionsLine.startsWith(VERSIONS_PREFIX)) {
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Can't read supported versions line:");
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, supportedVersionsLine);
            return false;
        }
        supportedVersionsLine = supportedVersionsLine.substring(VERSIONS_PREFIX.length());
        String[] supportedVersions = supportedVersionsLine.split(", ");
        String thisMinecraftVersion = Bukkit.getBukkitVersion();
        thisMinecraftVersion = thisMinecraftVersion.substring(0, thisMinecraftVersion.indexOf(45));
        for (String supportedVersion : supportedVersions) {
            if (!thisMinecraftVersion.equals(supportedVersion)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutdated() {
        return this.outdated;
    }
}

