/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.shaded.xseries.SkullUtils;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.shaded.xseries.XTag;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.SmartLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ItemFactory {
    private static final List<XMaterial> DYES = new ArrayList<XMaterial>(16);
    private static final List<XMaterial> STAINED_GLASS = new ArrayList<XMaterial>(16);
    private static final FixedMetadataValue UNPICKABLE_META = new FixedMetadataValue((Plugin)UltraCosmeticsData.get().getPlugin(), (Object)true);
    private static boolean noticePrinted;
    public static final ItemStack fillerItem;

    public static ItemStack create(XMaterial material, String displayName, String ... lore) {
        return ItemFactory.rename(material.parseItem(), displayName, lore);
    }

    public static ItemStack rename(ItemStack itemstack, String displayName) {
        return ItemFactory.rename(itemstack, displayName, null);
    }

    public static ItemStack rename(ItemStack itemstack, String displayName, String ... lore) {
        ItemMeta meta = itemstack.getItemMeta();
        meta.setDisplayName(displayName);
        if (lore != null) {
            List finalLore = meta.hasLore() ? meta.getLore() : new ArrayList();
            for (String s : lore) {
                if (s == null) continue;
                for (String line : s.split("\n")) {
                    finalLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
            }
            meta.setLore(finalLore);
        }
        itemstack.setItemMeta(meta);
        return itemstack;
    }

    public static Item setUnpickable(Item item) {
        item.setMetadata("UNPICKABLEUP", (MetadataValue)UNPICKABLE_META);
        return item;
    }

    public static Item spawnUnpickableItem(ItemStack stack, Location loc, Vector velocity) {
        Item item = loc.getWorld().dropItem(loc, stack);
        item.setVelocity(velocity);
        ItemFactory.setUnpickable(item);
        return item;
    }

    public static Item createUnpickableItemDirectional(XMaterial material, Player player, double scale) {
        return ItemFactory.spawnUnpickableItem(material.parseItem(), player.getEyeLocation(), player.getLocation().getDirection().multiply(scale));
    }

    public static Item createUnpickableItemVariance(XMaterial material, Location loc, Random random, double variance) {
        return ItemFactory.spawnUnpickableItem(material.parseItem(), loc, new Vector(random.nextDouble() - 0.5, random.nextDouble() / 2.0, random.nextDouble() - 0.5).multiply(variance));
    }

    public static void fillInventory(Inventory inventory) {
        if (SettingsManager.getConfig().getBoolean("Fill-Blank-Slots-With-Item.Enabled")) {
            for (int i = 0; i < inventory.getSize(); ++i) {
                if (inventory.getItem(i) != null && inventory.getItem(i).getType() != Material.AIR) continue;
                inventory.setItem(i, fillerItem);
            }
        }
    }

    public static ItemStack getItemStackFromConfig(String path) {
        XMaterial mat = ItemFactory.getFromConfigInternal(path);
        if (mat != null) {
            return mat.parseItem();
        }
        return ItemFactory.create(XMaterial.BEDROCK, "&cError parsing material", "&cFailed to parse material");
    }

    public static XMaterial getXMaterialFromConfig(String path) {
        XMaterial mat = ItemFactory.getFromConfigInternal(path);
        return mat == null ? XMaterial.BEDROCK : mat;
    }

    public static XMaterial getNullableXMaterialFromConfig(String path) {
        return ItemFactory.getFromConfigInternal(path);
    }

    public static List<XMaterial> getXMaterialListFromConfig(String path) {
        ArrayList<XMaterial> mats = new ArrayList<XMaterial>();
        CustomConfiguration cc = UltraCosmeticsData.get().getPlugin().getConfig();
        for (String matString : cc.getStringList(path)) {
            XMaterial.matchXMaterial(matString).ifPresent(m -> mats.add((XMaterial)((Object)m)));
        }
        return mats;
    }

    private static XMaterial getFromConfigInternal(String path) {
        String fromConfig = UltraCosmeticsData.get().getPlugin().getConfig().getString(path);
        if (fromConfig == null) {
            return null;
        }
        if (MathUtils.isInteger(fromConfig) || fromConfig.contains(":")) {
            if (!noticePrinted) {
                UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.ERROR, "UltraCosmetics no longer supports numeric IDs, please replace it with a material name.");
                noticePrinted = true;
            }
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Offending config path: " + path);
            return null;
        }
        return XMaterial.matchXMaterial(fromConfig).orElse(null);
    }

    public static ItemStack createSkull(String str, String name) {
        ItemStack head = ItemFactory.create(XMaterial.PLAYER_HEAD, name, new String[0]);
        ItemMeta meta = head.getItemMeta();
        SkullUtils.applySkin(meta, str);
        head.setItemMeta(meta);
        return head;
    }

    public static ItemStack createColouredLeather(Material armourPart, int red, int green, int blue) {
        ItemStack itemStack = new ItemStack(armourPart);
        LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
        leatherArmorMeta.setColor(Color.fromRGB((int)red, (int)green, (int)blue));
        itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
        return itemStack;
    }

    public static void addGlow(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.addEnchant(Enchantment.ARROW_DAMAGE, 1, true);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(itemMeta);
    }

    public static boolean haveSameName(ItemStack a, ItemStack b) {
        if (a.hasItemMeta() && b.hasItemMeta() && a.getItemMeta().hasDisplayName() && b.getItemMeta().hasDisplayName()) {
            return a.getItemMeta().getDisplayName().equals(b.getItemMeta().getDisplayName());
        }
        return false;
    }

    private static XMaterial randomXMaterial(List<XMaterial> mats) {
        return mats.get(ThreadLocalRandom.current().nextInt(mats.size()));
    }

    private static ItemStack randomStack(List<XMaterial> mats) {
        return ItemFactory.randomXMaterial(mats).parseItem();
    }

    public static ItemStack getRandomDye() {
        return ItemFactory.randomStack(DYES);
    }

    public static ItemStack getRandomStainedGlass() {
        return ItemFactory.randomStack(STAINED_GLASS);
    }

    public static ItemStack randomItemFromTag(XTag<XMaterial> tag) {
        return ItemFactory.randomFromTag(tag).parseItem();
    }

    public static XMaterial randomFromTag(XTag<XMaterial> tag) {
        return ItemFactory.randomXMaterial(new ArrayList<XMaterial>(tag.getValues()));
    }

    static {
        for (XMaterial mat : XMaterial.VALUES) {
            if (mat.name().endsWith("_DYE")) {
                DYES.add(mat);
                continue;
            }
            if (!mat.name().endsWith("_STAINED_GLASS")) continue;
            STAINED_GLASS.add(mat);
        }
        ItemStack itemStack = ItemFactory.getItemStackFromConfig("Fill-Blank-Slots-With-Item.Item");
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.GRAY + "");
        itemStack.setItemMeta(itemMeta);
        fillerItem = itemStack;
        noticePrinted = false;
    }
}

