/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EntitySpawner<T extends Entity>
extends BukkitRunnable {
    private final int limit = SettingsManager.getConfig().getInt("Max-Entity-Spawns-Per-Tick");
    private final EntityType type;
    private final Consumer<T> func;
    private final Location loc;
    private final boolean spread;
    private int remaining;
    private Set<T> entities = new HashSet<T>();
    private boolean scheduled = false;

    public EntitySpawner(EntityType type, Location loc, int amount, boolean spread, Consumer<T> func, UltraCosmetics ultraCosmetics) {
        this.type = type;
        this.loc = loc;
        this.remaining = amount;
        this.spread = spread;
        this.func = func;
        if (this.limit < 1 || amount <= this.limit) {
            this.run();
            return;
        }
        this.runTaskTimer((Plugin)ultraCosmetics, 0L, 1L);
        this.scheduled = true;
    }

    public EntitySpawner(EntityType type, Location loc, int amount, Consumer<T> func, UltraCosmetics ultraCosmetics) {
        this(type, loc, amount, false, func, ultraCosmetics);
    }

    public EntitySpawner(EntityType type, Location loc, int amount, UltraCosmetics ultraCosmetics) {
        this(type, loc, amount, e -> {}, ultraCosmetics);
    }

    public void run() {
        for (int i = 0; i < this.limit || this.limit == 0; ++i) {
            if (this.remaining < 1) {
                if (this.scheduled) {
                    this.cancel();
                }
                return;
            }
            Location spawnLoc = this.loc.clone();
            if (this.spread) {
                spawnLoc.add((double)(this.remaining % 5 - 2), 0.0, (double)(this.remaining / 4 - 2));
            }
            Entity entity = this.loc.getWorld().spawnEntity(spawnLoc, this.type);
            this.func.accept(entity);
            this.entities.add(entity);
            --this.remaining;
        }
    }

    public Set<T> getEntities() {
        return this.entities;
    }

    public void removeEntity(Entity entity) {
        entity.remove();
        this.entities.remove(entity);
    }

    public void removeEntities() {
        for (Entity entity : this.entities) {
            entity.remove();
        }
        this.entities.clear();
        try {
            this.cancel();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    public boolean contains(Entity entity) {
        return this.entities.contains(entity);
    }

    public static <K extends Entity> EntitySpawner<K> empty() {
        return new EntitySpawner(null, null, 0, null);
    }
}

