/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.version.VersionManager;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class BlockViewUpdater
extends BukkitRunnable {
    private static final Set<Block> blocksUpdating = ConcurrentHashMap.newKeySet();
    private Set<Block> blocks;

    public BlockViewUpdater(Set<Block> blocks) {
        this.blocks = blocks;
        BlockViewUpdater.addForProcessing(blocks);
    }

    public void run() {
        BlockViewUpdater.removeForProcessing(this.blocks);
        for (Block block : this.blocks) {
            for (Player player : block.getWorld().getPlayers()) {
                if (VersionManager.IS_VERSION_1_13) {
                    player.sendBlockChange(block.getLocation(), block.getBlockData());
                    continue;
                }
                player.sendBlockChange(block.getLocation(), block.getType(), block.getData());
            }
        }
    }

    public static boolean isUpdating(Block block) {
        return blocksUpdating.contains(block);
    }

    private static synchronized void addForProcessing(Set<Block> blocks) {
        blocks.removeAll(blocksUpdating);
        blocksUpdating.addAll(blocks);
    }

    private static synchronized void removeForProcessing(Set<Block> blocks) {
        blocksUpdating.removeAll(blocks);
    }
}

