/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetRocket;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.shaded.xseries.XTag;
import be.isach.ultracosmetics.util.BlockViewUpdater;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.version.VersionManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BlockUtils {
    public static final List<Block> treasureBlocks = new ArrayList<Block>();
    private static final Set<Material> badMaterials = new HashSet<Material>();
    private static final Set<Material> AIRS = new HashSet<Material>();

    public static List<Block> getBlocksInRadius(Location location, int radius, boolean hollow) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int bX = location.getBlockX();
        int bY = location.getBlockY();
        int bZ = location.getBlockZ();
        for (int x = bX - radius; x <= bX + radius; ++x) {
            for (int y = bY - radius; y <= bY + radius; ++y) {
                for (int z = bZ - radius; z <= bZ + radius; ++z) {
                    Location l;
                    double distance = (bX - x) * (bX - x) + (bY - y) * (bY - y) + (bZ - z) * (bZ - z);
                    if (!(distance < (double)(radius * radius)) || hollow && distance < (double)((radius - 1) * (radius - 1)) || (l = new Location(location.getWorld(), (double)x, (double)y, (double)z)).getBlock().getType() == Material.BARRIER) continue;
                    blocks.add(l.getBlock());
                }
            }
        }
        return blocks;
    }

    public static boolean isOnGround(Entity entity) {
        Block block = entity.getLocation().getBlock().getRelative(BlockFace.DOWN);
        return block.getType().isSolid();
    }

    public static boolean isRocketBlock(Block b) {
        for (GadgetRocket rocket : GadgetRocket.ROCKETS_WITH_BLOCKS) {
            if (!rocket.containsBlock(b)) continue;
            return true;
        }
        return false;
    }

    public static void setToRestoreIgnoring(Map<Block, XMaterial> blocks, int tickDelay) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)UltraCosmeticsData.get().getPlugin(), () -> {
            blocks.keySet().removeIf(BlockViewUpdater::isUpdating);
            if (blocks.size() == 0) {
                return;
            }
            World world = ((Block)blocks.keySet().iterator().next()).getWorld();
            for (Map.Entry entry : blocks.entrySet()) {
                for (Player player : world.getPlayers()) {
                    if (VersionManager.IS_VERSION_1_13) {
                        player.sendBlockChange(((Block)entry.getKey()).getLocation(), Bukkit.createBlockData((Material)((XMaterial)((Object)((Object)entry.getValue()))).parseMaterial()));
                        continue;
                    }
                    player.sendBlockChange(((Block)entry.getKey()).getLocation(), ((XMaterial)((Object)((Object)entry.getValue()))).parseMaterial(), ((XMaterial)((Object)((Object)entry.getValue()))).getData());
                }
            }
            new BlockViewUpdater(blocks.keySet()).runTaskLaterAsynchronously((Plugin)UltraCosmeticsData.get().getPlugin(), tickDelay);
        });
    }

    public static void setToRestore(Map<Block, XMaterial> blocks, int tickDelay) {
        blocks.keySet().removeIf(b -> !BlockUtils.canRestore(b));
        BlockUtils.setToRestoreIgnoring(blocks, tickDelay);
    }

    public static boolean canRestore(Block block) {
        return !badMaterials.contains(block.getType()) && !SettingsManager.getConfig().getStringList("Gadgets.PaintballGun.BlackList").contains(block.getType().name()) && !BlockUtils.isPortalBlock(block) && !BlockUtils.isRocketBlock(block) && !BlockUtils.isTreasureChestBlock(block) && block.getType().isSolid() && BlockUtils.okAboveBlock(block.getRelative(BlockFace.UP).getType());
    }

    public static boolean isTreasureChestBlock(Block block) {
        return treasureBlocks.contains(block);
    }

    private static boolean okAboveBlock(Material mat) {
        return BlockUtils.isAir(mat) || mat.isSolid();
    }

    public static boolean isPortalBlock(Block b) {
        for (BlockFace face : BlockFace.values()) {
            if (b.getRelative(face).getType() != XMaterial.NETHER_PORTAL.parseMaterial()) continue;
            return true;
        }
        return false;
    }

    public static boolean isBadMaterial(Material mat) {
        return badMaterials.contains(mat);
    }

    public static boolean isAir(Material mat) {
        return AIRS.contains(mat);
    }

    public static FallingBlock spawnFallingBlock(Location loc, Material type) {
        if (VersionManager.IS_VERSION_1_13) {
            return loc.getWorld().spawnFallingBlock(loc, type.createBlockData());
        }
        return loc.getWorld().spawnFallingBlock(loc, type, (byte)0);
    }

    public static FallingBlock spawnFallingBlock(Location loc, Block source) {
        if (VersionManager.IS_VERSION_1_13) {
            return loc.getWorld().spawnFallingBlock(loc, source.getBlockData());
        }
        return loc.getWorld().spawnFallingBlock(loc, source.getType(), source.getData());
    }

    static {
        for (String name : SettingsManager.getConfig().getStringList("Air-Materials")) {
            Optional<XMaterial> optional = XMaterial.matchXMaterial(name);
            if (!optional.isPresent()) {
                UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Failed to parse 'Air-Materials' item: " + name);
                continue;
            }
            Material parsed = optional.get().parseMaterial();
            if (parsed == null) continue;
            AIRS.add(parsed);
        }
        HashSet<XMaterial> badXMaterials = new HashSet<XMaterial>();
        badXMaterials.add(XMaterial.CHEST);
        badXMaterials.add(XMaterial.ACACIA_WALL_SIGN);
        badXMaterials.add(XMaterial.BIRCH_WALL_SIGN);
        badXMaterials.add(XMaterial.DARK_OAK_WALL_SIGN);
        badXMaterials.add(XMaterial.JUNGLE_WALL_SIGN);
        badXMaterials.add(XMaterial.OAK_WALL_SIGN);
        badXMaterials.add(XMaterial.DARK_OAK_WALL_SIGN);
        badXMaterials.add(XMaterial.WHEAT);
        badXMaterials.add(XMaterial.GRASS);
        badXMaterials.add(XMaterial.DEAD_BUSH);
        badXMaterials.add(XMaterial.POPPY);
        badXMaterials.add(XMaterial.RED_MUSHROOM);
        badXMaterials.add(XMaterial.BROWN_MUSHROOM);
        badXMaterials.add(XMaterial.TORCH);
        badXMaterials.add(XMaterial.LADDER);
        badXMaterials.add(XMaterial.VINE);
        badXMaterials.add(XMaterial.LARGE_FERN);
        badXMaterials.add(XMaterial.LILAC);
        badXMaterials.add(XMaterial.PEONY);
        badXMaterials.add(XMaterial.ROSE_BUSH);
        badXMaterials.add(XMaterial.SUNFLOWER);
        badXMaterials.add(XMaterial.NETHER_PORTAL);
        badXMaterials.add(XMaterial.CACTUS);
        badXMaterials.add(XMaterial.WATER);
        badXMaterials.add(XMaterial.LAVA);
        badXMaterials.add(XMaterial.END_PORTAL);
        badXMaterials.add(XMaterial.FARMLAND);
        badXMaterials.add(XMaterial.BARRIER);
        badXMaterials.add(XMaterial.COMMAND_BLOCK);
        badXMaterials.add(XMaterial.DROPPER);
        badXMaterials.add(XMaterial.DISPENSER);
        badXMaterials.addAll(XTag.WOODEN_SLABS.getValues());
        badXMaterials.addAll(XTag.NON_WOODEN_SLABS.getValues());
        badXMaterials.addAll(XTag.DOORS.getValues());
        badXMaterials.addAll(XTag.SIGNS.getValues());
        badXMaterials.addAll(XTag.BEDS.getValues());
        badXMaterials.addAll(XTag.PRESSURE_PLATES.getValues());
        badXMaterials.addAll(XTag.BANNERS.getValues());
        badXMaterials.addAll(XTag.SAPLINGS.getValues());
        for (XMaterial xMaterial : badXMaterials) {
            badMaterials.add(xMaterial.parseMaterial());
        }
        badMaterials.addAll(AIRS);
    }
}

