/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.SmartLogger;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class Area {
    private static final boolean DEBUG = SettingsManager.getConfig().getBoolean("Area-Debug");
    protected final World world;
    protected final int x1;
    protected final int y1;
    protected final int z1;
    protected final int x2;
    protected final int y2;
    protected final int z2;

    public Area(Location loc1, Location loc2) {
        if (loc1.getWorld() != loc2.getWorld()) {
            throw new IllegalArgumentException("Locations cannot be in different worlds");
        }
        this.world = loc1.getWorld();
        this.x1 = Math.min(loc1.getBlockX(), loc2.getBlockX());
        this.y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        this.z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        this.x2 = Math.max(loc1.getBlockX(), loc2.getBlockX());
        this.y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        this.z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
    }

    public Area(Location center, int radius, int yUp) {
        this(center.clone().add((double)(-radius), 0.0, (double)(-radius)), center.clone().add((double)radius, (double)yUp, (double)radius));
    }

    public boolean isEmptyExcept(int badX, int badY, int badZ, Function<Material, Boolean> okMatFunc) {
        for (int x = this.x1; x <= this.x2; ++x) {
            for (int y = this.y1; y <= this.y2; ++y) {
                for (int z = this.z1; z <= this.z2; ++z) {
                    if (x == badX && y == badY && z == badZ || okMatFunc.apply(this.world.getBlockAt(x, y, z).getType()).booleanValue()) continue;
                    if (DEBUG) {
                        SmartLogger log = UltraCosmeticsData.get().getPlugin().getSmartLogger();
                        log.write("Failed area check at (" + x + "," + y + "," + z + ") because it is " + this.world.getBlockAt(x, y, z).getType());
                    }
                    return false;
                }
            }
        }
        if (DEBUG) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write("Area check passed");
        }
        return true;
    }

    public boolean isEmptyExcept(Location loc) {
        return this.isEmptyExcept(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), m -> BlockUtils.isAir(m));
    }

    public boolean isEmpty() {
        return this.isEmptyExcept(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, m -> BlockUtils.isAir(m));
    }

    public boolean isTransparent() {
        return this.isEmptyExcept(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, m -> m.isTransparent());
    }

    public boolean contains(Block block) {
        return block.getWorld() == this.world && block.getX() >= this.x1 && block.getX() <= this.x2 && block.getY() >= this.y1 && block.getY() <= this.y2 && block.getZ() >= this.z1 && block.getZ() <= this.z2;
    }
}

