/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.treasurechests.CommandReward;
import be.isach.ultracosmetics.util.WeightedSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;

public class TreasureRandomizer {
    private static final int MONEY_CHANCE = SettingsManager.getConfig().getInt("TreasureChests.Loots.Money.Chance");
    private static final int AMMO_CHANCE = SettingsManager.getConfig().getInt("TreasureChests.Loots.Gadgets-Ammo.Chance");
    private static final Random random = new Random();
    private final WeightedSet<ResultType> basicResultTypes = new WeightedSet();
    private final List<CommandReward> commandRewardList = new ArrayList<CommandReward>();
    private final Map<ResultType, WeightedSet<CosmeticType<?>>> cosmetics = new HashMap();
    private Location loc;
    private final Player player;
    private final boolean forceMessageToOwner;
    private ItemStack itemStack;
    private String name;

    public TreasureRandomizer(Player player, Location location, boolean forceMessageToOwner) {
        this.loc = location.add(0.5, 0.0, 0.5);
        this.player = player;
        this.forceMessageToOwner = forceMessageToOwner;
        if (Category.GADGETS.isEnabled() && UltraCosmeticsData.get().isAmmoEnabled() && SettingsManager.getConfig().getBoolean("TreasureChests.Loots.Gadgets-Ammo.Enabled")) {
            for (GadgetType type : GadgetType.values()) {
                if (!type.isEnabled() || !type.requiresAmmo() || !type.canBeFound() || !player.hasPermission(type.getPermission())) continue;
                this.cosmetics.computeIfAbsent(ResultType.AMMO, k -> new WeightedSet()).add(type, type.getChestWeight());
            }
        }
        CustomConfiguration config = UltraCosmeticsData.get().getPlugin().getConfig();
        for (String key : config.getConfigurationSection("TreasureChests.Loots.Commands").getKeys(false)) {
            String cancelPermission;
            String path = "TreasureChests.Loots.Commands." + key;
            if (!config.getBoolean(path + ".Enabled") || !(cancelPermission = config.getString(path + ".Cancel-If-Permission")).equals("no") && player.hasPermission(cancelPermission)) continue;
            this.commandRewardList.add(new CommandReward(path));
        }
        for (Category cat : Category.values()) {
            this.setupChance(cat);
        }
        if (UltraCosmeticsData.get().useMoneyTreasureLoot()) {
            this.addWeightedResult(MONEY_CHANCE, ResultType.MONEY);
        }
        for (CommandReward commandReward : this.commandRewardList) {
            this.addWeightedResult(commandReward.getChance(), ResultType.COMMAND);
        }
    }

    public TreasureRandomizer(Player player, Location location) {
        this(player, location, false);
    }

    private void setupChance(Category category) {
        String configPath = "TreasureChests.Loots." + category.getMessagesName();
        if (!SettingsManager.getConfig().getBoolean(configPath + ".Enabled")) {
            return;
        }
        if (!category.isEnabled()) {
            return;
        }
        ResultType result = ResultType.fromCategory(category);
        for (CosmeticType<?> type : category.getEnabled()) {
            if (!type.isEnabled() || type.getChestWeight() < 1 || this.player.hasPermission(type.getPermission())) continue;
            this.cosmetics.computeIfAbsent(result, k -> new WeightedSet()).add(type, type.getChestWeight());
        }
    }

    private void addWeightedResult(int weight, ResultType type) {
        this.basicResultTypes.add(type, weight);
    }

    private FireworkEffect getRandomFireworkEffect() {
        if (!UltraCosmeticsData.get().getPlugin().isEnabled()) {
            return null;
        }
        FireworkEffect.Builder builder = FireworkEffect.builder();
        return builder.flicker(false).trail(false).with(FireworkEffect.Type.BALL).withColor(TreasureRandomizer.randomColor()).withFade(TreasureRandomizer.randomColor()).build();
    }

    private static Color randomColor() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        return Color.fromRGB((int)((Random)r).nextInt(255), (int)((Random)r).nextInt(255), (int)((Random)r).nextInt(255));
    }

    private String getConfigMessage(String s) {
        String message = SettingsManager.getConfig().getString(s);
        if (message == null) {
            return ChatColor.RED.toString() + ChatColor.BOLD.toString() + "Error";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message.replace("%prefix%", MessageManager.getMessage("Prefix")));
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void giveRandomThing() {
        XSound.BLOCK_CHEST_OPEN.play(this.loc, 1.4f, 1.5f);
        WeightedSet<ResultType> choices = new WeightedSet<ResultType>(this.basicResultTypes);
        for (ResultType result : this.cosmetics.keySet()) {
            int weight = result.category == null ? AMMO_CHANCE : SettingsManager.getConfig().getInt("TreasureChests.Loots." + result.category.getMessagesName() + ".Chance");
            choices.add(result, weight);
        }
        if (choices.size() == 0) {
            this.giveFallback();
            return;
        }
        ResultType type = choices.getRandom();
        switch (type) {
            case MONEY: {
                this.giveMoney();
                break;
            }
            case AMMO: {
                this.giveAmmo();
                break;
            }
            case MOUNT: {
                this.giveRandomCosmetic(type, "Mount", "Mounts");
                break;
            }
            case MORPH: {
                this.giveRandomCosmetic(type, "Morph", "Morphs");
                break;
            }
            case PET: {
                this.giveRandomCosmetic(type, "Pet", "Pets");
                break;
            }
            case EFFECT: {
                this.giveRandomCosmetic(type, "Effect", "Effects");
                break;
            }
            case HAT: {
                this.giveRandomCosmetic(type, "Hat", "Hats");
                break;
            }
            case GADGET: {
                this.giveRandomCosmetic(type, "Gadget", "Gadgets");
                break;
            }
            case SUIT: {
                this.giveRandomCosmetic(type, "Suit", "Suits");
                break;
            }
            case EMOTE: {
                this.giveRandomCosmetic(type, "Emote", "Emotes");
                break;
            }
            case COMMAND: {
                this.giveRandomCommandReward();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void giveFallback() {
        if (UltraCosmeticsData.get().getPlugin().getEconomyHandler().isUsingEconomy()) {
            this.giveMoney();
        } else {
            this.giveNothing();
        }
    }

    public void giveNothing() {
        this.name = MessageManager.getMessage("Treasure-Chests-Loot.Nothing");
        this.itemStack = new ItemStack(Material.BARRIER);
    }

    private int randomInRange(int min, int max) {
        if (min < max) {
            return random.nextInt(max - min) + min;
        }
        return min;
    }

    public void giveMoney() {
        int min = SettingsManager.getConfig().getInt("TreasureChests.Loots.Money.Min");
        int max = SettingsManager.getConfig().getInt("TreasureChests.Loots.Money.Max");
        int money = this.randomInRange(min, max);
        this.name = MessageManager.getMessage("Treasure-Chests-Loot.Money").replace("%money%", money + "");
        UltraCosmeticsData.get().getPlugin().getEconomyHandler().deposit(this.player, money);
        this.itemStack = XMaterial.SUNFLOWER.parseItem();
        if (money > 3 * SettingsManager.getConfig().getInt("TreasureChests.Loots.Money.Max") / 4) {
            this.spawnRandomFirework(this.loc);
        }
        boolean toOthers = SettingsManager.getConfig().getBoolean("TreasureChests.Loots.Money.Message.enabled");
        this.broadcast(this.getConfigMessage("TreasureChests.Loots.Money.Message.message").replace("%money%", String.valueOf(money)), toOthers);
    }

    public void giveAmmo() {
        GadgetType g = (GadgetType)this.cosmetics.get((Object)ResultType.AMMO).getRandom();
        int ammoMin = SettingsManager.getConfig().getInt("TreasureChests.Loots.Gadgets-Ammo.Min");
        int ammoMax = SettingsManager.getConfig().getInt("TreasureChests.Loots.Gadgets-Ammo.Max");
        int ammo = this.randomInRange(ammoMin, ammoMax);
        this.name = MessageManager.getMessage("Treasure-Chests-Loot.Ammo").replace("%name%", g.getName()).replace("%ammo%", String.valueOf(ammo));
        UltraCosmeticsData.get().getPlugin().getPlayerManager().getUltraPlayer(this.player).addAmmo(g, ammo);
        this.itemStack = g.getMaterial().parseItem();
        if (ammo > (ammoMax - ammoMin) / 2 + ammoMin) {
            this.spawnRandomFirework(this.loc);
        }
        boolean toOthers = SettingsManager.getConfig().getBoolean("TreasureChests.Loots.Gadgets-Ammo.Message.enabled");
        this.broadcast(this.getConfigMessage("TreasureChests.Loots.Gadgets-Ammo.Message.message").replace("%ammo%", String.valueOf(ammo)).replace("%gadget%", UltraCosmeticsData.get().arePlaceholdersColored() ? g.getName() : ChatColor.stripColor((String)g.getName())), toOthers);
    }

    private CosmeticType<?> getRandomCosmetic(ResultType result) {
        CosmeticType<?> cosmetic = this.cosmetics.get((Object)result).removeRandom();
        if (this.cosmetics.get((Object)result).size() == 0) {
            this.cosmetics.remove((Object)result);
        }
        return cosmetic;
    }

    public void giveRandomCosmetic(ResultType result, String lang, String configName) {
        CosmeticType<?> cosmetic = this.getRandomCosmetic(result);
        this.name = MessageManager.getMessage("Treasure-Chests-Loot." + lang).replace("%" + lang.toLowerCase() + "%", cosmetic.getName());
        this.givePermission(cosmetic.getPermission());
        this.spawnRandomFirework(this.loc);
        this.itemStack = cosmetic.getItemStack();
        boolean toOthers = SettingsManager.getConfig().getBoolean("TreasureChests.Loots." + configName + ".Message.enabled");
        String message = this.getConfigMessage("TreasureChests.Loots." + configName + ".Message.message").replace("%" + lang.toLowerCase() + "%", UltraCosmeticsData.get().arePlaceholdersColored() ? cosmetic.getName() : ChatColor.stripColor((String)cosmetic.getName()));
        this.broadcast(message, toOthers);
    }

    public void giveRandomCommandReward() {
        WeightedSet<CommandReward> rewards = new WeightedSet<CommandReward>();
        for (CommandReward commandReward : this.commandRewardList) {
            rewards.add(commandReward, commandReward.getChance());
        }
        CommandReward reward = (CommandReward)rewards.getRandom();
        rewards.clear();
        for (String command : reward.getCommands()) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%name%", this.player.getName()));
        }
        this.name = reward.getName().replace("%name%", this.player.getName());
        this.itemStack = reward.getItemStack();
        this.spawnRandomFirework(this.loc);
        this.broadcast(ChatColor.translateAlternateColorCodes((char)'&', (String)reward.getMessage().replace("%prefix%", MessageManager.getMessage("Prefix"))), reward.getMessageEnabled());
    }

    public void givePermission(Permission permission) {
        UltraCosmeticsData.get().getPlugin().getPermissionProvider().setPermission(this.player, permission);
    }

    public void spawnRandomFirework(Location location) {
        if (!UltraCosmeticsData.get().getPlugin().isEnabled()) {
            return;
        }
        ArrayList<Firework> fireworks = new ArrayList<Firework>();
        for (int i = 0; i < 4; ++i) {
            Firework f = (Firework)this.player.getWorld().spawn(location.clone().add(0.5, 0.0, 0.5), Firework.class);
            FireworkMeta fm = f.getFireworkMeta();
            fm.addEffect(this.getRandomFireworkEffect());
            f.setFireworkMeta(fm);
            fireworks.add(f);
            f.setMetadata("uc_firework", (MetadataValue)new FixedMetadataValue((Plugin)UltraCosmeticsData.get().getPlugin(), (Object)1));
        }
        Bukkit.getScheduler().runTaskLater((Plugin)UltraCosmeticsData.get().getPlugin(), () -> {
            for (Firework f : fireworks) {
                f.detonate();
            }
        }, 2L);
    }

    private void broadcast(String message, boolean toOthers) {
        message = message.replace("%name%", this.player.getName());
        if (!toOthers) {
            if (this.forceMessageToOwner) {
                this.player.sendMessage(message);
            }
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player != this.player && (!SettingsManager.isAllowedWorld(player.getWorld()) || !UltraCosmeticsData.get().getPlugin().getPlayerManager().getUltraPlayer(player).isTreasureNotifying())) continue;
            player.sendMessage(message);
        }
    }

    public void setLocation(Location newLoc) {
        this.loc = newLoc;
    }

    public static enum ResultType {
        AMMO,
        GADGET(Category.GADGETS),
        MONEY,
        MORPH(Category.MORPHS),
        MOUNT(Category.MOUNTS),
        EFFECT(Category.EFFECTS),
        PET(Category.PETS),
        HAT(Category.HATS),
        SUIT(Category.SUITS),
        EMOTE(Category.EMOTES),
        COMMAND;

        private final Category category;

        private ResultType() {
            this(null);
        }

        private ResultType(Category category) {
            this.category = category;
        }

        private static ResultType fromCategory(Category cat) {
            for (ResultType type : ResultType.values()) {
                if (type.category != cat) continue;
                return type;
            }
            return null;
        }
    }
}

