/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import be.isach.ultracosmetics.treasurechests.PlaceBlocksRunnable;
import be.isach.ultracosmetics.treasurechests.PlayerBounceRunnable;
import be.isach.ultracosmetics.treasurechests.TreasureChestDesign;
import be.isach.ultracosmetics.treasurechests.TreasureLocation;
import be.isach.ultracosmetics.treasurechests.TreasureRandomizer;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.Particles;
import be.isach.ultracosmetics.util.SmartLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TreasureChest
implements Listener {
    private final Map<Block, BlockState> blocksToRestore = new HashMap<Block, BlockState>();
    private final List<Block> chests = new ArrayList<Block>();
    private final List<Block> chestsToRemove = new ArrayList<Block>();
    private final UUID owner;
    private TreasureRandomizer randomGenerator;
    private Location center;
    private final Particles particleEffect;
    private int chestsLeft = SettingsManager.getConfig().getInt("TreasureChests.Count", 4);
    private Player player;
    private Set<Item> items = new HashSet<Item>();
    private Set<ArmorStand> holograms = new HashSet<ArmorStand>();
    private boolean stopping;
    private boolean cooldown = false;
    private final TreasureChestDesign design;
    private final Location preLoc;
    private final TreasureLocation treasureLoc;
    private final PlaceBlocksRunnable blocksRunnable;

    public TreasureChest(UUID owner, TreasureChestDesign design, Location preLoc, TreasureLocation destLoc) {
        this.design = design;
        this.particleEffect = design.getEffect();
        this.owner = owner;
        this.preLoc = preLoc;
        this.treasureLoc = destLoc;
        UltraCosmetics uc = UltraCosmeticsData.get().getPlugin();
        UltraPlayerManager pm = uc.getPlayerManager();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)uc);
        this.player = this.getPlayer();
        Location loc = this.getPlayer().getLocation().getBlock().getLocation();
        Block centerPossibleBlock = loc.getBlock();
        if (!BlockUtils.isAir(centerPossibleBlock.getType())) {
            this.blocksToRestore.put(centerPossibleBlock, centerPossibleBlock.getState());
            centerPossibleBlock.setType(Material.AIR);
        }
        if (pm.getUltraPlayer(this.getPlayer()).getCurrentMorph() != null) {
            pm.getUltraPlayer(this.getPlayer()).setSeeSelfMorph(false);
        }
        this.randomGenerator = new TreasureRandomizer(this.getPlayer(), this.getPlayer().getLocation());
        this.blocksRunnable = new PlaceBlocksRunnable(this);
        this.blocksRunnable.runTaskTimer((Plugin)uc, 0L, 12L);
        Bukkit.getScheduler().runTaskLater((Plugin)uc, () -> {
            if (pm.getUltraPlayer(this.player) != null && pm.getUltraPlayer(this.player).getCurrentTreasureChest() == this) {
                this.forceOpen(45);
            }
        }, 1200L);
        pm.getUltraPlayer(this.getPlayer()).setCurrentTreasureChest(this);
        new PlayerBounceRunnable(this).runTaskTimer((Plugin)uc, 0L, 1L);
    }

    public Player getPlayer() {
        if (this.owner != null) {
            return Bukkit.getPlayer((UUID)this.owner);
        }
        return null;
    }

    public void clear() {
        for (Map.Entry<Block, BlockState> entry : this.blocksToRestore.entrySet()) {
            entry.getValue().update(true);
            BlockUtils.treasureBlocks.remove(entry.getKey());
        }
        this.blocksToRestore.clear();
        if (this.stopping) {
            this.cleanup();
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)UltraCosmeticsData.get().getPlugin(), () -> this.cleanup(), 30L);
        }
    }

    private void cleanup() {
        for (ArmorStand hologram : this.holograms) {
            hologram.remove();
        }
        for (Item item : this.items) {
            item.remove();
        }
        for (Block b : this.chestsToRemove) {
            b.setType(Material.AIR);
        }
        for (Block b : this.chests) {
            b.setType(Material.AIR);
        }
        this.cancelRunnables();
        this.items.clear();
        this.chests.clear();
        this.holograms.clear();
        this.chestsToRemove.clear();
        if (this.getPlayer() != null) {
            UltraCosmeticsData.get().getPlugin().getPlayerManager().getUltraPlayer(this.getPlayer()).setCurrentTreasureChest(null);
            if (this.preLoc != null) {
                this.getPlayer().teleport(this.preLoc);
            }
        }
        HandlerList.unregisterAll((Listener)this);
    }

    private void cancelRunnables() {
        this.blocksRunnable.propogateCancel();
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (event.getPlayer() == this.getPlayer() && !event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            event.setCancelled(true);
            event.getPlayer().teleport(event.getFrom());
        }
    }

    public void forceOpen(int delay) {
        if (delay == 0) {
            this.stopping = true;
            for (int i = 0; i < this.chestsLeft; ++i) {
                this.randomGenerator.giveRandomThing();
                this.getPlayer().sendMessage(MessageManager.getMessage("You-Won-Treasure-Chests").replace("%name%", this.randomGenerator.getName()));
            }
            return;
        }
        for (Block b : this.chests) {
            UltraCosmeticsData.get().getVersionManager().getEntityUtil().playChestAnimation(b, true, this.design);
            this.randomGenerator.setLocation(b.getLocation().clone().add(0.0, 1.0, 0.0));
            this.randomGenerator.giveRandomThing();
            ItemStack is = this.randomGenerator.getItemStack();
            this.items.add(this.spawnItem(is, b.getLocation()));
            String name = this.randomGenerator.getName();
            Bukkit.getScheduler().runTaskLater((Plugin)UltraCosmeticsData.get().getPlugin(), () -> this.spawnHologram(b.getLocation().clone().add(0.5, 0.3, 0.5), name), 15L);
            --this.chestsLeft;
            this.chestsToRemove.add(b);
        }
        this.chests.clear();
        Bukkit.getScheduler().runTaskLater((Plugin)UltraCosmeticsData.get().getPlugin(), this::clear, (long)delay);
    }

    @EventHandler
    public void onBreakBlock(BlockBreakEvent event) {
        if (this.blocksToRestore.containsKey(event.getBlock()) || this.chests.contains(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    private void spawnHologram(Location location, String s) {
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        armorStand.setSmall(true);
        armorStand.setVisible(false);
        armorStand.setBasePlate(false);
        armorStand.setCustomName(s);
        armorStand.setCustomNameVisible(true);
        armorStand.setMetadata("C_AD_ArmorStand", (MetadataValue)new FixedMetadataValue((Plugin)UltraCosmeticsData.get().getPlugin(), (Object)"C_AD_ArmorStand"));
        this.holograms.add(armorStand);
    }

    public boolean isSpecialEntity(Entity entity) {
        return this.items.contains(entity) || this.holograms.contains(entity);
    }

    @EventHandler
    public void onInter(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null || !this.chests.contains(event.getClickedBlock())) {
            return;
        }
        event.setCancelled(true);
        if (event.getPlayer() != this.getPlayer() || this.cooldown) {
            return;
        }
        UltraCosmeticsData.get().getVersionManager().getEntityUtil().playChestAnimation(event.getClickedBlock(), true, this.design);
        this.randomGenerator.setLocation(event.getClickedBlock().getLocation().add(0.0, 1.0, 0.0));
        this.randomGenerator.giveRandomThing();
        this.cooldown = true;
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)UltraCosmeticsData.get().getPlugin(), () -> {
            this.cooldown = false;
        }, 3L);
        ItemStack is = this.randomGenerator.getItemStack();
        this.items.add(this.spawnItem(is, event.getClickedBlock().getLocation()));
        String name = this.randomGenerator.getName();
        Bukkit.getScheduler().runTaskLater((Plugin)UltraCosmeticsData.get().getPlugin(), () -> this.spawnHologram(event.getClickedBlock().getLocation().add(0.5, 0.3, 0.5), name), 15L);
        --this.chestsLeft;
        this.chests.remove(event.getClickedBlock());
        this.chestsToRemove.add(event.getClickedBlock());
        if (this.chestsLeft == 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)UltraCosmeticsData.get().getPlugin(), this::clear, 50L);
        }
    }

    private Item spawnItem(ItemStack stack, Location loc) {
        return ItemFactory.spawnUnpickableItem(stack, loc.clone().add(0.5, 1.2, 0.5), new Vector(0.0, 0.25, 0.0));
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        if (event.getPlayer() == this.getPlayer() && event.getReason().equals("Flying is not enabled on this server")) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.INFO, "Cancelled flight kick while opening treasure chest");
            event.setCancelled(true);
            event.getPlayer().teleport(this.center);
        }
    }

    public TreasureLocation getTreasureLocation() {
        return this.treasureLoc;
    }

    public Particles getParticleEffect() {
        return this.particleEffect;
    }

    protected void setCenter(Location loc) {
        this.center = loc;
    }

    public Location getCenter() {
        return this.center.clone();
    }

    public TreasureChestDesign getDesign() {
        return this.design;
    }

    public void addChest(Block b) {
        this.chests.add(b);
    }

    public void addRestoreBlock(Block b) {
        this.blocksToRestore.put(b, b.getState());
    }

    public int getChestsLeft() {
        return this.chestsLeft;
    }

    protected void setChestsLeft(int chestsLeft) {
        this.chestsLeft = chestsLeft;
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        if (this.items.contains(event.getEntity()) || this.items.contains(event.getTarget())) {
            event.setCancelled(true);
        }
    }
}

