/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import be.isach.ultracosmetics.util.MathUtils;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PlayerBounceRunnable
extends BukkitRunnable {
    private final TreasureChest chest;

    public PlayerBounceRunnable(TreasureChest chest) {
        this.chest = chest;
    }

    public void run() {
        Player player = this.chest.getPlayer();
        UltraPlayerManager pm = UltraCosmeticsData.get().getPlugin().getPlayerManager();
        UltraPlayer ultraPlayer = pm.getUltraPlayer(player);
        if (ultraPlayer == null || ultraPlayer.getCurrentTreasureChest() != this.chest) {
            this.cancel();
            return;
        }
        Location center = this.chest.getCenter();
        if (player.getWorld() != center.getWorld()) {
            player.teleport(center);
        }
        if (player.getLocation().distanceSquared(center) > 2.25) {
            player.teleport(center);
        }
        for (Entity ent : player.getNearbyEntities(2.0, 2.0, 2.0)) {
            UltraPlayer up;
            if (ent == player || this.chest.isSpecialEntity(ent) || (up = pm.getUltraPlayer(player)).getCurrentPet() != null && (ent == up.getCurrentPet() || up.getCurrentPet().getItems().contains(ent))) continue;
            Vector v = ent.getLocation().toVector().subtract(player.getLocation().toVector()).multiply(0.5).setY(1);
            MathUtils.applyVelocity(ent, v.add(MathUtils.getRandomCircleVector().multiply(0.2)));
        }
    }
}

