/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.shaded.xseries.XBlock;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import be.isach.ultracosmetics.util.Particles;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.scheduler.BukkitRunnable;

public class PlaceChestRunnable
extends BukkitRunnable {
    private final TreasureChest chest;
    private final Location chestLocation;
    private final int locationIndex;

    public PlaceChestRunnable(TreasureChest chest, Location chestLocation, int locationIndex) {
        this.chest = chest;
        this.chestLocation = chestLocation;
        this.locationIndex = locationIndex;
    }

    public void run() {
        Block b = this.chestLocation.getBlock();
        b.setType(this.chest.getDesign().getChestType().getType());
        XSound.BLOCK_ANVIL_LAND.play((Entity)this.chest.getPlayer(), 1.4f, 1.5f);
        Particles.SMOKE_LARGE.display(b.getLocation(), 5);
        Particles.LAVA.display(b.getLocation(), 5);
        BlockFace blockFace = BlockFace.SOUTH;
        switch (this.locationIndex) {
            case 4: {
                blockFace = BlockFace.SOUTH;
                break;
            }
            case 3: {
                blockFace = BlockFace.NORTH;
                break;
            }
            case 2: {
                blockFace = BlockFace.EAST;
                break;
            }
            case 1: {
                blockFace = BlockFace.WEST;
            }
        }
        XBlock.setDirection(b, blockFace);
        this.chest.addChest(b);
    }
}

