/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import be.isach.ultracosmetics.shaded.xseries.XBlock;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.treasurechests.ChestParticleRunnable;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import be.isach.ultracosmetics.treasurechests.TreasureChestDesign;
import be.isach.ultracosmetics.util.BlockUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlaceBlocksRunnable
extends BukkitRunnable {
    private static final BlockFace[] SURROUNDING_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.SOUTH_EAST, BlockFace.NORTH_WEST, BlockFace.NORTH_EAST, BlockFace.SOUTH_WEST};
    private final TreasureChest chest;
    private final TreasureChestDesign design;
    private final UltraCosmetics uc = UltraCosmeticsData.get().getPlugin();
    private int i = 5;
    private ChestParticleRunnable particleRunnable = null;

    public PlaceBlocksRunnable(TreasureChest chest) {
        this.chest = chest;
        this.design = chest.getDesign();
    }

    public void run() {
        Player player = this.chest.getPlayer();
        UltraPlayerManager pm = this.uc.getPlayerManager();
        if (player == null || pm.getUltraPlayer(player).getCurrentTreasureChest() != this.chest) {
            this.cancel();
            return;
        }
        if (this.i == 0) {
            this.particleRunnable = new ChestParticleRunnable(this.chest);
            this.particleRunnable.runTaskTimer((Plugin)this.uc, 0L, 50L);
            this.cancel();
            return;
        }
        if (this.i == 5) {
            Block lampBlock = player.getLocation().add(0.0, -1.0, 0.0).getBlock();
            this.chest.setCenter(lampBlock.getLocation().add(0.5, 1.0, 0.5));
            this.doChestStage(Arrays.asList(lampBlock), this.design.getCenter());
        } else if (this.i == 4) {
            this.doChestStage(this.getSurroundingBlocks(this.chest.getCenter().clone().add(0.0, -1.0, 0.0).getBlock()), this.design.getBlocks2());
        } else if (this.i == 3) {
            this.doChestStage(this.getSurroundingSurrounding(this.chest.getCenter().clone().add(0.0, -1.0, 0.0).getBlock()), this.design.getBlocks3());
        } else if (this.i == 2) {
            this.doChestStage(this.getBlock3(this.chest.getCenter().clone().add(0.0, -1.0, 0.0).getBlock()), this.design.getBelowChests());
        } else if (this.i == 1) {
            this.doChestStage(this.getSurroundingSurrounding(this.chest.getCenter().getBlock()), this.design.getBarriers());
        }
        --this.i;
    }

    private void doChestStage(Iterable<Block> blocks, XMaterial newData) {
        if (newData == null) {
            return;
        }
        for (Block b : blocks) {
            this.chest.addRestoreBlock(b);
            BlockUtils.treasureBlocks.add(b);
            XBlock.setType(b, newData);
        }
    }

    public List<Block> getSurroundingBlocks(Block b) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (BlockFace face : SURROUNDING_FACES) {
            blocks.add(b.getRelative(face));
        }
        return blocks;
    }

    private List<Block> getSurroundingSurrounding(Block b) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int x = -2; x <= 2; ++x) {
            if (x == 0) continue;
            for (int z = -2; z <= 2; ++z) {
                if (z == 0 || Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                blocks.add(b.getRelative(x, 0, z));
            }
        }
        return blocks;
    }

    private List<Block> getBlock3(Block b) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        blocks.add(b.getRelative(-2, 0, 0));
        blocks.add(b.getRelative(2, 0, 0));
        blocks.add(b.getRelative(0, 0, 2));
        blocks.add(b.getRelative(0, 0, -2));
        return blocks;
    }

    public void propogateCancel() {
        this.cancel();
        if (this.particleRunnable != null) {
            this.particleRunnable.propogateCancel();
        }
    }
}

