/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public class CommandReward {
    private String name;
    private ItemStack stack;
    private int chance;
    private boolean messageEnabled;
    private String message;
    private List<String> commands;

    public CommandReward(String path) {
        CustomConfiguration config = UltraCosmeticsData.get().getPlugin().getConfig();
        this.chance = config.getInt(path + ".Chance");
        this.messageEnabled = config.getBoolean(path + ".Message.enabled");
        this.message = config.getString(path + ".Message.message");
        this.commands = config.getStringList(path + ".Commands");
        this.stack = ItemFactory.getItemStackFromConfig(path + ".Material");
        this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString(path + ".Name"));
    }

    public int getChance() {
        return this.chance;
    }

    public boolean getMessageEnabled() {
        return this.messageEnabled;
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getItemStack() {
        return this.stack.clone();
    }
}

