/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.treasurechests.PlaceChestRunnable;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import be.isach.ultracosmetics.util.Particles;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChestParticleRunnable
extends BukkitRunnable {
    private final TreasureChest chest;
    private final UltraCosmetics uc;
    private int i;
    private PlaceChestRunnable chestRunnable = null;

    public ChestParticleRunnable(TreasureChest chest) {
        this.chest = chest;
        this.uc = UltraCosmeticsData.get().getPlugin();
        this.i = chest.getChestsLeft();
    }

    public void run() {
        if (this.i <= 0) {
            this.cancel();
            return;
        }
        Player player = this.chest.getPlayer();
        if (player == null || this.uc.getPlayerManager().getUltraPlayer(player).getCurrentTreasureChest() != this.chest) {
            this.cancel();
            return;
        }
        int animationTime = 0;
        Particles particleEffect = this.chest.getParticleEffect();
        if (particleEffect != null) {
            particleEffect.playHelix(this.getChestLocation(), 0.0f);
            particleEffect.playHelix(this.getChestLocation(), 3.5f);
            animationTime = 30;
        }
        this.chestRunnable = new PlaceChestRunnable(this.chest, this.getChestLocation(), this.i--);
        this.chestRunnable.runTaskLater((Plugin)this.uc, animationTime);
    }

    private Location getChestLocation() {
        Location chestLocation = this.chest.getCenter();
        chestLocation.setX((double)chestLocation.getBlockX() + 0.5);
        chestLocation.setY((double)chestLocation.getBlockY());
        chestLocation.setZ((double)chestLocation.getBlockZ() + 0.5);
        switch (this.i) {
            case 1: {
                chestLocation.add(2.0, 0.0, 0.0);
                break;
            }
            case 2: {
                chestLocation.add(-2.0, 0.0, 0.0);
                break;
            }
            case 3: {
                chestLocation.add(0.0, 0.0, 2.0);
                break;
            }
            case 4: {
                chestLocation.add(0.0, 0.0, -2.0);
            }
        }
        return chestLocation;
    }

    public void propogateCancel() {
        this.cancel();
        if (this.chestRunnable != null) {
            this.chestRunnable.cancel();
        }
    }
}

