/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.player.profile;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.cosmetics.type.SuitCategory;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.mysql.StandardQuery;
import be.isach.ultracosmetics.mysql.Table;
import be.isach.ultracosmetics.player.profile.ProfileKey;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;

public class PlayerData {
    private UUID uuid;
    private int keys;
    private boolean gadgetsEnabled;
    private boolean morphSelfView;
    private boolean treasureNotifications;
    private boolean filterByOwned;
    private Map<PetType, String> petNames = new HashMap<PetType, String>();
    private Map<GadgetType, Integer> ammo = new HashMap<GadgetType, Integer>();
    private Map<Category, CosmeticType<?>> enabledCosmetics = new HashMap();
    private Map<ArmorSlot, SuitType> enabledSuitParts = new HashMap<ArmorSlot, SuitType>();

    public PlayerData(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getKeys() {
        return this.keys;
    }

    public void setKeys(int keys) {
        this.keys = keys;
    }

    public boolean isGadgetsEnabled() {
        return this.gadgetsEnabled;
    }

    public void setGadgetsEnabled(boolean gadgetsEnabled) {
        this.gadgetsEnabled = gadgetsEnabled;
    }

    public boolean isMorphSelfView() {
        return this.morphSelfView;
    }

    public void setMorphSelfView(boolean morphSelfView) {
        this.morphSelfView = morphSelfView;
    }

    public boolean isTreasureNotifications() {
        return this.treasureNotifications;
    }

    public void setTreasureNotifications(boolean treasureNotifications) {
        this.treasureNotifications = treasureNotifications;
    }

    public boolean isFilterByOwned() {
        return this.filterByOwned;
    }

    public void setFilterByOwned(boolean filterByOwned) {
        this.filterByOwned = filterByOwned;
    }

    public Map<PetType, String> getPetNames() {
        return this.petNames;
    }

    public Map<GadgetType, Integer> getAmmo() {
        return this.ammo;
    }

    public Map<Category, CosmeticType<?>> getEnabledCosmetics() {
        return this.enabledCosmetics;
    }

    public Map<ArmorSlot, SuitType> getEnabledSuitParts() {
        return this.enabledSuitParts;
    }

    public void loadFromFile() {
        SettingsManager sm = SettingsManager.getData(this.uuid);
        if (UltraCosmeticsData.get().areCosmeticsProfilesEnabled() && sm.fileConfiguration.isConfigurationSection("enabled")) {
            this.cosmeticsFromFile(sm);
        }
        for (PetType pet : PetType.enabled()) {
            this.petNames.put(pet, sm.getString(ProfileKey.PET_NAMES.getFileKey() + "." + pet.getConfigName()));
        }
        for (GadgetType gadget : GadgetType.enabled()) {
            this.ammo.put(gadget, sm.getInt(ProfileKey.AMMO.getFileKey() + "." + gadget.getConfigName().toLowerCase()));
        }
        this.keys = sm.getInt(ProfileKey.KEYS.getFileKey());
        this.gadgetsEnabled = sm.getBoolean(ProfileKey.GADGETS_ENABLED.getFileKey(), true);
        this.morphSelfView = sm.getBoolean(ProfileKey.MORPH_VIEW.getFileKey(), true);
        this.treasureNotifications = sm.getBoolean(ProfileKey.TREASURE_NOTIFICATION.getFileKey(), true);
        this.filterByOwned = sm.getBoolean(ProfileKey.FILTER_OWNED.getFileKey(), false);
    }

    private void cosmeticsFromFile(SettingsManager sm) {
        ConfigurationSection s = sm.fileConfiguration.getConfigurationSection("enabled");
        boolean changed = false;
        for (Category cat : Category.values()) {
            String value;
            if (cat == Category.SUITS) continue;
            String key = cat.toString().toLowerCase();
            String oldKey = key.substring(0, key.length() - 1);
            if (s.isString(oldKey)) {
                value = s.getString(oldKey);
                s.set(key, (Object)value);
                s.set(oldKey, null);
                changed = true;
            } else {
                value = s.getString(key);
            }
            if (value == null || value.equals("none")) continue;
            this.enabledCosmetics.put(cat, cat.valueOfType(value));
        }
        String suitKey = Category.SUITS.toString().toLowerCase();
        String oldSuitKey = suitKey.substring(0, suitKey.length() - 1);
        if (s.isConfigurationSection(oldSuitKey)) {
            ConfigurationSection value = s.getConfigurationSection(oldSuitKey);
            s.set(suitKey, (Object)value);
            s.set(oldSuitKey, null);
            changed = true;
        }
        for (ArmorSlot slot : ArmorSlot.values()) {
            String slotKey = slot.toString().toLowerCase();
            String value = s.getString(suitKey + "." + slotKey);
            if (value == null || value.equals("none")) continue;
            this.enabledCosmetics.put(Category.SUITS, SuitCategory.valueOf(value.toUpperCase()).getPiece(slot));
        }
        if (changed) {
            sm.save();
        }
    }

    public void saveToFile() {
        SettingsManager data = SettingsManager.getData(this.uuid);
        data.set(ProfileKey.KEYS.getFileKey(), this.keys);
        data.set(ProfileKey.GADGETS_ENABLED.getFileKey(), this.gadgetsEnabled);
        data.set(ProfileKey.MORPH_VIEW.getFileKey(), this.morphSelfView);
        data.set(ProfileKey.TREASURE_NOTIFICATION.getFileKey(), this.treasureNotifications);
        data.set(ProfileKey.FILTER_OWNED.getFileKey(), this.filterByOwned);
        for (Category category : Category.enabled()) {
            if (category == Category.SUITS) continue;
            CosmeticType<?> type = this.enabledCosmetics.get((Object)category);
            data.set("enabled." + category.toString().toLowerCase(), type == null ? null : type.getConfigName().toLowerCase());
        }
        for (ArmorSlot slot : ArmorSlot.values()) {
            SuitType type = this.enabledSuitParts.get((Object)slot);
            data.set("enabled." + Category.SUITS.toString().toLowerCase() + "." + slot.toString().toLowerCase(), type == null ? null : type.getConfigName().toLowerCase());
        }
        for (Map.Entry entry : this.petNames.entrySet()) {
            data.set(ProfileKey.PET_NAMES.getFileKey() + "." + ((PetType)entry.getKey()).getConfigName(), entry.getValue());
        }
        for (Map.Entry entry : this.ammo.entrySet()) {
            Integer amount = (Integer)entry.getValue();
            if (amount != null && amount == 0) {
                amount = null;
            }
            data.set(ProfileKey.AMMO.getFileKey() + "." + ((GadgetType)entry.getKey()).getConfigName().toLowerCase(), amount);
        }
        data.save();
    }

    public void loadFromSQL() {
        Table table = UltraCosmeticsData.get().getPlugin().getMySqlConnectionManager().getTable();
        table.insertIgnore().insert("uuid", this.uuid.toString()).execute();
        Map<String, Object> properties = table.select("*").uuid(this.uuid).getAll();
        this.gadgetsEnabled = (Boolean)properties.get(ProfileKey.GADGETS_ENABLED.getSqlKey());
        this.morphSelfView = (Boolean)properties.get(ProfileKey.MORPH_VIEW.getSqlKey());
        this.treasureNotifications = (Boolean)properties.get(ProfileKey.TREASURE_NOTIFICATION.getSqlKey());
        this.filterByOwned = (Boolean)properties.get(ProfileKey.FILTER_OWNED.getSqlKey());
        for (PetType petType : PetType.enabled()) {
            this.petNames.put(petType, (String)properties.get(Table.cleanCosmeticName(petType)));
        }
        for (GadgetType gadgetType : GadgetType.enabled()) {
            this.ammo.put(gadgetType, (int)((Integer)properties.get(Table.cleanCosmeticName(gadgetType))));
        }
        this.keys = (Integer)properties.get(ProfileKey.KEYS.getSqlKey());
        if (!UltraCosmeticsData.get().areCosmeticsProfilesEnabled()) {
            return;
        }
        for (Category category : Category.enabled()) {
            if (category == Category.SUITS) {
                for (ArmorSlot slot : ArmorSlot.values()) {
                    String suitCategory = (String)properties.get(Category.SUITS.toString().toLowerCase() + "_" + slot.toString().toLowerCase());
                    if (suitCategory == null) continue;
                    this.enabledSuitParts.put(slot, SuitCategory.valueOf(suitCategory.toUpperCase()).getPiece(slot));
                }
                continue;
            }
            this.enabledCosmetics.put(category, category.valueOfType((String)properties.get(Table.cleanCategoryName(category))));
        }
    }

    public void saveToSQL() {
        Table table = UltraCosmeticsData.get().getPlugin().getMySqlConnectionManager().getTable();
        table.insertIgnore().insert("uuid", this.uuid.toString()).execute();
        StandardQuery query = table.update().uuid(this.uuid);
        query.set(ProfileKey.KEYS.getSqlKey(), this.keys);
        query.set(ProfileKey.GADGETS_ENABLED.getSqlKey(), this.gadgetsEnabled);
        query.set(ProfileKey.MORPH_VIEW.getSqlKey(), this.morphSelfView);
        query.set(ProfileKey.TREASURE_NOTIFICATION.getSqlKey(), this.treasureNotifications);
        query.set(ProfileKey.FILTER_OWNED.getSqlKey(), this.filterByOwned);
        this.petNames.forEach((k, v) -> query.set(Table.cleanCosmeticName(k), v));
        this.ammo.forEach((k, v) -> query.set(Table.cleanCosmeticName(k), v == null ? 0 : v));
        this.enabledCosmetics.forEach((k, v) -> query.set(Table.cleanCategoryName(k), Table.cleanCosmeticName(v)));
        this.enabledSuitParts.forEach((k, v) -> query.set(Table.cleanCategoryName(Category.SUITS) + "_" + k.toString().toLowerCase(), Table.cleanCosmeticName(v)));
        query.execute();
    }
}

