/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.player.profile;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.player.profile.PlayerData;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class CosmeticsProfile {
    protected final UltraPlayer ultraPlayer;
    protected final UUID uuid;
    protected final UltraCosmetics ultraCosmetics;
    protected final PlayerData data;

    public CosmeticsProfile(UltraPlayer ultraPlayer, UltraCosmetics ultraCosmetics) {
        this.ultraPlayer = ultraPlayer;
        this.uuid = ultraPlayer.getUUID();
        this.ultraCosmetics = ultraCosmetics;
        this.data = new PlayerData(this.uuid);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)ultraCosmetics, () -> {
            this.load();
            if (!CosmeticsProfile.shouldLoadCosmetics()) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)ultraCosmetics, () -> this.equip());
        });
    }

    protected static boolean shouldLoadCosmetics() {
        return UltraCosmeticsData.get().areCosmeticsProfilesEnabled();
    }

    protected abstract void load();

    public abstract void save();

    public void equip() {
        if (!this.ultraPlayer.isOnline()) {
            return;
        }
        if (!SettingsManager.isAllowedWorld(this.ultraPlayer.getBukkitPlayer().getWorld())) {
            return;
        }
        for (Map.Entry<Category, CosmeticType<?>> entry : this.data.getEnabledCosmetics().entrySet()) {
            if (entry.getValue() == null || !entry.getKey().isEnabled() || !entry.getValue().isEnabled()) continue;
            entry.getValue().equip(this.ultraPlayer, this.ultraCosmetics);
        }
        if (Category.SUITS.isEnabled()) {
            for (SuitType suitType : this.data.getEnabledSuitParts().values()) {
                if (suitType == null || !suitType.isEnabled()) continue;
                suitType.equip(this.ultraPlayer, this.ultraCosmetics);
            }
        }
    }

    public void setEnabledCosmetic(Category cat, Cosmetic<?> cosmetic) {
        this.setEnabledCosmetic(cat, cosmetic == null ? null : (CosmeticType<?>)cosmetic.getType());
    }

    public void setEnabledCosmetic(Category cat, CosmeticType<?> type) {
        if (cat == Category.SUITS) {
            if (type == null) {
                throw new IllegalArgumentException("Updating Suit state requires a slot parameter");
            }
            SuitType suit = (SuitType)type;
            this.setEnabledSuitPart(suit.getSlot(), suit);
            return;
        }
        this.data.getEnabledCosmetics().put(cat, type);
    }

    public void setEnabledSuitPart(ArmorSlot slot, SuitType suitType) {
        this.data.getEnabledSuitParts().put(slot, suitType);
    }

    public int getAmmo(GadgetType gadget) {
        return this.data.getAmmo().getOrDefault(gadget, 0);
    }

    public void setAmmo(GadgetType type, int amount) {
        this.data.getAmmo().put(type, amount);
    }

    public void addAmmo(GadgetType type, int amount) {
        this.setAmmo(type, this.getAmmo(type) + amount);
    }

    public String getPetName(PetType pet) {
        return this.data.getPetNames().get(pet);
    }

    public void setPetName(PetType pet, String name) {
        this.data.getPetNames().put(pet, name);
    }

    public int getKeys() {
        return this.data.getKeys();
    }

    public void setKeys(int amount) {
        this.data.setKeys(amount);
    }

    public void addKeys(int amount) {
        this.setKeys(this.getKeys() + amount);
    }

    public void setGadgetsEnabled(boolean enabled) {
        this.data.setGadgetsEnabled(enabled);
    }

    public boolean hasGadgetsEnabled() {
        return this.data.isGadgetsEnabled();
    }

    public void setSeeSelfMorph(boolean enabled) {
        this.data.setMorphSelfView(enabled);
    }

    public boolean canSeeSelfMorph() {
        return this.data.isMorphSelfView();
    }

    public boolean isTreasureNotifications() {
        return this.data.isTreasureNotifications();
    }

    public void setTreasureNotifications(boolean treasureNotifications) {
        this.data.setTreasureNotifications(treasureNotifications);
    }

    public boolean isFilterByOwned() {
        return this.data.isFilterByOwned();
    }

    public void setFilterByOwned(boolean filterByOwned) {
        this.data.setFilterByOwned(filterByOwned);
    }
}

