/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.player;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.listeners.ClientBrandListener;
import be.isach.ultracosmetics.player.UltraPlayer;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class UltraPlayerManager {
    private Map<UUID, UltraPlayer> playerCache = new ConcurrentHashMap<UUID, UltraPlayer>();
    private UltraCosmetics ultraCosmetics;

    public UltraPlayerManager(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
    }

    public UltraPlayer getUltraPlayer(Player player) {
        if (player == null) {
            return null;
        }
        return this.playerCache.computeIfAbsent(player.getUniqueId(), u -> new UltraPlayer((UUID)u, this.ultraCosmetics));
    }

    public boolean remove(Player player) {
        return this.playerCache.remove(player.getUniqueId()) != null;
    }

    public Collection<UltraPlayer> getUltraPlayers() {
        return this.playerCache.values();
    }

    public void initPlayers() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!SettingsManager.getConfig().getBoolean("Menu-Item.Enabled") || !SettingsManager.isAllowedWorld(p.getWorld())) continue;
            this.getUltraPlayer(p).giveMenuItem();
        }
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.ultraCosmetics, "minecraft:brand", (PluginMessageListener)new ClientBrandListener(this.ultraCosmetics));
    }

    public void dispose() {
        Collection<UltraPlayer> set = this.playerCache.values();
        for (UltraPlayer cp : set) {
            cp.setQuitting(true);
            if (cp.getCurrentTreasureChest() != null) {
                cp.getCurrentTreasureChest().forceOpen(0);
            }
            cp.saveCosmeticsProfile();
            cp.clear();
            cp.removeMenuItem();
        }
        this.playerCache.clear();
        this.playerCache = null;
    }
}

