/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.player;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.emotes.Emote;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.hats.Hat;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.mounts.Mount;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffect;
import be.isach.ultracosmetics.cosmetics.pets.Pet;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.suits.Suit;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.menu.PurchaseData;
import be.isach.ultracosmetics.menu.menus.MenuMain;
import be.isach.ultracosmetics.menu.menus.MenuPurchase;
import be.isach.ultracosmetics.mysql.SqlCache;
import be.isach.ultracosmetics.player.profile.CosmeticsProfile;
import be.isach.ultracosmetics.player.profile.FileCosmeticsProfile;
import be.isach.ultracosmetics.run.FallDamageManager;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.ServerVersion;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class UltraPlayer {
    private final UUID uuid;
    private final UltraCosmetics ultraCosmetics;
    private final Map<Category, Cosmetic<?>> equipped = new HashMap();
    private final Map<ArmorSlot, Suit> suitMap = new HashMap<ArmorSlot, Suit>();
    private TreasureChest currentTreasureChest;
    private final CosmeticsProfile cosmeticsProfile;
    private boolean canBeHitByOtherGadgets = true;
    private final Map<GadgetType, Long> gadgetCooldowns = new HashMap<GadgetType, Long>();
    private volatile boolean moving;
    private volatile Location lastPos;
    private boolean quitting = false;
    private String clientBrand = null;
    private int lastGadgetPage = 1;

    public UltraPlayer(UUID uuid, UltraCosmetics ultraCosmetics) {
        this.uuid = uuid;
        this.ultraCosmetics = ultraCosmetics;
        this.cosmeticsProfile = UltraCosmeticsData.get().usingFileStorage() ? new FileCosmeticsProfile(this, ultraCosmetics) : new SqlCache(this, ultraCosmetics);
    }

    public double getCooldown(GadgetType gadget) {
        Long count = this.gadgetCooldowns.get(gadget);
        if (count == null || System.currentTimeMillis() > count) {
            return 0.0;
        }
        double valueMillis = count - System.currentTimeMillis();
        return valueMillis / 1000.0;
    }

    public boolean canUse(GadgetType gadget) {
        return this.getCooldown(gadget) == 0.0;
    }

    public void setCoolDown(GadgetType gadget) {
        double cooldown = gadget.getCountdown();
        if (this.isBypassingCooldown()) {
            cooldown = gadget.getRunTime();
        }
        this.gadgetCooldowns.put(gadget, (long)(cooldown * 1000.0 + (double)System.currentTimeMillis()));
    }

    public Player getBukkitPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public Cosmetic<?> getCosmetic(Category category) {
        if (category == Category.SUITS) {
            throw new IllegalArgumentException("Can't use generic getCosmetic for suit category!");
        }
        return this.equipped.get((Object)category);
    }

    public ParticleEffect getCurrentParticleEffect() {
        return (ParticleEffect)this.getCosmetic(Category.EFFECTS);
    }

    public Emote getCurrentEmote() {
        return (Emote)this.getCosmetic(Category.EMOTES);
    }

    public Gadget getCurrentGadget() {
        return (Gadget)this.getCosmetic(Category.GADGETS);
    }

    public Hat getCurrentHat() {
        return (Hat)this.getCosmetic(Category.HATS);
    }

    public Morph getCurrentMorph() {
        return (Morph)this.getCosmetic(Category.MORPHS);
    }

    public Mount getCurrentMount() {
        return (Mount)this.getCosmetic(Category.MOUNTS);
    }

    public Pet getCurrentPet() {
        return (Pet)this.getCosmetic(Category.PETS);
    }

    public boolean hasCosmetic(Category category) {
        return this.equipped.containsKey((Object)category);
    }

    public boolean removeCosmetic(Category category) {
        if (category == Category.SUITS) {
            return this.removeSuit();
        }
        if (!this.equipped.containsKey((Object)category)) {
            return false;
        }
        this.unsetCosmetic(category).clear();
        return true;
    }

    public Cosmetic<?> unsetCosmetic(Category category) {
        if (!this.isQuitting()) {
            this.cosmeticsProfile.setEnabledCosmetic(category, (CosmeticType)null);
        }
        return this.equipped.remove((Object)category);
    }

    public void setCosmeticEquipped(Cosmetic<?> cosmetic) {
        if (cosmetic instanceof Suit) {
            Suit suit = (Suit)cosmetic;
            if (this.hasSuitPartOn(suit.getArmorSlot())) {
                this.removeSuit(suit.getArmorSlot());
            }
            this.setCurrentSuitPart(suit.getArmorSlot(), suit);
            return;
        }
        this.removeCosmetic(cosmetic.getCategory());
        this.equipped.put(cosmetic.getCategory(), cosmetic);
        if (!this.isQuitting()) {
            this.cosmeticsProfile.setEnabledCosmetic(cosmetic.getCategory(), cosmetic);
        }
    }

    public void addKeys(int amount) {
        this.cosmeticsProfile.addKeys(amount);
    }

    public void addKey() {
        this.addKeys(1);
    }

    public void removeKey() {
        this.addKeys(-1);
    }

    public int getKeys() {
        return this.cosmeticsProfile.getKeys();
    }

    public void saveCosmeticsProfile() {
        this.cosmeticsProfile.save();
    }

    public void setCurrentSuitPart(ArmorSlot armorSlot, Suit suit) {
        if (suit == null) {
            this.suitMap.remove((Object)armorSlot);
        } else {
            this.suitMap.put(armorSlot, suit);
        }
        if (!this.isQuitting()) {
            this.cosmeticsProfile.setEnabledSuitPart(armorSlot, suit == null ? null : (SuitType)suit.getType());
        }
    }

    public boolean removeSuit(ArmorSlot armorSlot) {
        if (!this.suitMap.containsKey((Object)armorSlot)) {
            return false;
        }
        this.getSuit(armorSlot).clear();
        this.setCurrentSuitPart(armorSlot, null);
        return true;
    }

    public double getBalance() {
        if (this.ultraCosmetics.getEconomyHandler().isUsingEconomy()) {
            return this.ultraCosmetics.getEconomyHandler().balance(this.getBukkitPlayer());
        }
        return 0.0;
    }

    public boolean hasPermission(String permission) {
        return this.getBukkitPlayer().hasPermission(permission);
    }

    public boolean hasPermission(Permission permission) {
        return this.getBukkitPlayer().hasPermission(permission);
    }

    public Suit getSuit(ArmorSlot armorSlot) {
        return this.suitMap.get((Object)armorSlot);
    }

    public boolean hasSuitOn() {
        return this.suitMap.size() > 0;
    }

    public boolean hasSuitPartOn(ArmorSlot slot) {
        return this.suitMap.containsKey((Object)slot);
    }

    public boolean removeSuit() {
        boolean removedSomething = false;
        for (ArmorSlot armorSlot : ArmorSlot.values()) {
            if (!this.removeSuit(armorSlot)) continue;
            removedSomething = true;
        }
        return removedSomething;
    }

    public boolean hasCosmeticsEquipped() {
        return this.equipped.size() > 0 || this.suitMap.size() > 0;
    }

    public boolean clear() {
        boolean toReturn = this.hasCosmeticsEquipped();
        if (Category.MORPHS.isEnabled() && Bukkit.getPluginManager().isPluginEnabled("LibsDisguises") && (this.isQuitting() || SettingsManager.isAllowedWorld(this.getBukkitPlayer().getWorld()))) {
            this.removeCosmetic(Category.MORPHS);
        }
        for (Category cat : Category.values()) {
            if (cat == Category.MORPHS) continue;
            this.removeCosmetic(cat);
        }
        this.removeTreasureChest();
        return toReturn;
    }

    public void openKeyPurchaseMenu() {
        if (!this.ultraCosmetics.getEconomyHandler().isUsingEconomy()) {
            return;
        }
        int price = SettingsManager.getConfig().getInt("TreasureChests.Key-Price");
        if (price < 1) {
            return;
        }
        if (!this.getBukkitPlayer().hasPermission("ultracosmetics.treasurechests.buykey")) {
            this.getBukkitPlayer().sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "You don't have permission to buy Treasure Keys.");
            return;
        }
        ItemStack itemStack = ItemFactory.create(XMaterial.TRIPWIRE_HOOK, ChatColor.translateAlternateColorCodes((char)'&', (String)MessageManager.getMessage("Buy-Treasure-Key-ItemName").replace("%price%", String.valueOf(price))), new String[0]);
        PurchaseData pd = new PurchaseData();
        pd.setPrice(price);
        pd.setShowcaseItem(itemStack);
        pd.setOnPurchase(() -> {
            this.addKey();
            MenuMain.openMainMenu(this);
        });
        pd.setOnCancel(() -> MenuMain.openMainMenu(this));
        MenuPurchase mp = new MenuPurchase(this.ultraCosmetics, MessageManager.getMessage("Buy-Treasure-Key"), pd);
        Bukkit.getScheduler().runTaskLater((Plugin)this.ultraCosmetics, () -> this.getBukkitPlayer().openInventory(mp.getInventory(this)), 1L);
    }

    public void setPetName(PetType petType, String name) {
        if (name.isEmpty()) {
            name = null;
        }
        this.cosmeticsProfile.setPetName(petType, name);
        if (this.hasCosmetic(Category.PETS)) {
            ((Pet)this.getCosmetic(Category.PETS)).updateName();
        }
    }

    public String getPetName(PetType petType) {
        return this.cosmeticsProfile.getPetName(petType);
    }

    public void addAmmo(GadgetType type, int amount) {
        if (UltraCosmeticsData.get().isAmmoEnabled()) {
            this.cosmeticsProfile.addAmmo(type, amount);
            Gadget gadget = this.getCurrentGadget();
            if (gadget == null) {
                return;
            }
            this.getBukkitPlayer().getInventory().setItem(SettingsManager.getConfig().getInt("Gadget-Slot"), ItemFactory.create(((GadgetType)gadget.getType()).getMaterial(), ChatColor.WHITE + "" + ChatColor.BOLD + this.getAmmo((GadgetType)gadget.getType()) + " " + ((GadgetType)gadget.getType()).getName(), MessageManager.getMessage("Gadgets.Lore")));
        }
    }

    public void applyVelocity(Vector vector) {
        this.getBukkitPlayer().setVelocity(vector);
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)UltraCosmeticsData.get().getPlugin(), () -> FallDamageManager.addNoFall((Entity)this.getBukkitPlayer()), 2L);
    }

    public void setGadgetsEnabled(boolean enabled) {
        this.cosmeticsProfile.setGadgetsEnabled(enabled);
        if (enabled) {
            this.getBukkitPlayer().sendMessage(MessageManager.getMessage("Enabled-Gadgets"));
        } else {
            this.getBukkitPlayer().sendMessage(MessageManager.getMessage("Disabled-Gadgets"));
        }
    }

    public boolean hasGadgetsEnabled() {
        return this.cosmeticsProfile.hasGadgetsEnabled();
    }

    public void setSeeSelfMorph(boolean enabled) {
        this.cosmeticsProfile.setSeeSelfMorph(enabled);
        if (enabled) {
            this.getBukkitPlayer().sendMessage(MessageManager.getMessage("Enabled-SelfMorphView"));
        } else {
            this.getBukkitPlayer().sendMessage(MessageManager.getMessage("Disabled-SelfMorphView"));
        }
        if (this.hasCosmetic(Category.MORPHS)) {
            this.getCurrentMorph().setSeeSelf(enabled);
        }
    }

    public boolean canSeeSelfMorph() {
        return this.cosmeticsProfile.canSeeSelfMorph();
    }

    public int getAmmo(GadgetType type) {
        if (!UltraCosmeticsData.get().isAmmoEnabled()) {
            return 0;
        }
        return this.cosmeticsProfile.getAmmo(type);
    }

    public void removeTreasureChest() {
        if (this.currentTreasureChest == null) {
            return;
        }
        this.currentTreasureChest.clear();
        this.currentTreasureChest = null;
    }

    public void removeAmmo(GadgetType type) {
        this.addAmmo(type, -1);
    }

    public void giveMenuItem() {
        if (this.getBukkitPlayer() == null) {
            return;
        }
        this.removeMenuItem();
        ConfigurationSection section = SettingsManager.getConfig().getConfigurationSection("Menu-Item");
        int slot = section.getInt("Slot");
        ItemStack slotItem = this.getBukkitPlayer().getInventory().getItem(slot);
        if (slotItem != null) {
            if (slotItem.hasItemMeta() && slotItem.getItemMeta().hasDisplayName() && slotItem.getItemMeta().getDisplayName().equalsIgnoreCase(section.getString("Displayname"))) {
                this.getBukkitPlayer().getInventory().setItem(slot, null);
            }
            this.getBukkitPlayer().getWorld().dropItemNaturally(this.getBukkitPlayer().getLocation(), slotItem);
            this.getBukkitPlayer().getInventory().setItem(slot, null);
        }
        String name = ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("Displayname"));
        int model = section.getInt("Custom-Model-Data");
        ItemStack stack = ItemFactory.rename(ItemFactory.getItemStackFromConfig("Menu-Item.Type"), name);
        ItemMeta meta = stack.getItemMeta();
        String lore = ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("Lore"));
        meta.setLore(Arrays.asList(lore.split("\n")));
        if (UltraCosmeticsData.get().getServerVersion().isAtLeast(ServerVersion.v1_14) && model != 0) {
            meta.setCustomModelData(Integer.valueOf(model));
        }
        stack.setItemMeta(meta);
        this.getBukkitPlayer().getInventory().setItem(slot, stack);
    }

    public void removeMenuItem() {
        if (this.getBukkitPlayer() == null) {
            return;
        }
        int slot = SettingsManager.getConfig().getInt("Menu-Item.Slot");
        ItemStack slotItem = this.getBukkitPlayer().getInventory().getItem(slot);
        if (slotItem != null && slotItem.hasItemMeta() && slotItem.getItemMeta().hasDisplayName() && slotItem.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)SettingsManager.getConfig().getString("Menu-Item.Displayname")))) {
            this.getBukkitPlayer().getInventory().setItem(slot, null);
        }
    }

    public void sendMessage(Object message) {
        this.getBukkitPlayer().sendMessage(message.toString());
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public TreasureChest getCurrentTreasureChest() {
        return this.currentTreasureChest;
    }

    public void setCurrentTreasureChest(TreasureChest currentTreasureChest) {
        this.currentTreasureChest = currentTreasureChest;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public Location getLastPos() {
        return this.lastPos;
    }

    public void setLastPos(Location lastPos) {
        this.lastPos = lastPos;
    }

    public void setCanBeHitByOtherGadgets(boolean canBeHitByOtherGadgets) {
        this.canBeHitByOtherGadgets = canBeHitByOtherGadgets;
    }

    public boolean canBeHitByOtherGadgets() {
        return this.canBeHitByOtherGadgets;
    }

    public boolean isOnline() {
        return Bukkit.getServer().getPlayer(this.uuid) != null;
    }

    public boolean isQuitting() {
        return this.quitting;
    }

    public void setQuitting(boolean quitting) {
        this.quitting = quitting;
    }

    public boolean isBypassingCooldown() {
        return this.getBukkitPlayer().hasPermission("ultracosmetics.bypass.cooldown");
    }

    public void equipProfile() {
        this.cosmeticsProfile.equip();
    }

    public boolean isFilteringByOwned() {
        return this.cosmeticsProfile.isFilterByOwned();
    }

    public void setFilteringByOwned(boolean filterByOwned) {
        this.cosmeticsProfile.setFilterByOwned(filterByOwned);
    }

    public boolean isTreasureNotifying() {
        return this.cosmeticsProfile.isTreasureNotifications();
    }

    public void setTreasureNotifying(boolean treasureNotifications) {
        this.cosmeticsProfile.setTreasureNotifications(treasureNotifications);
    }

    public boolean isGeyserClient() {
        return "Geyser".equals(this.clientBrand);
    }

    public void setClientBrand(String brand) {
        this.clientBrand = brand;
    }

    public int getGadgetsPage() {
        return this.lastGadgetPage;
    }

    public void setGadgetsPage(int gadgetsPage) {
        this.lastGadgetPage = gadgetsPage;
    }
}

