/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.placeholderapi;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.type.EmoteType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.HatType;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.player.UltraPlayer;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class PlaceholderHook
extends PlaceholderExpansion {
    private UltraCosmetics ultraCosmetics;

    public PlaceholderHook(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        UltraPlayer ultraPlayer = this.ultraCosmetics.getPlayerManager().getUltraPlayer(player);
        if (identifier.startsWith("ammo_")) {
            String gadget = identifier.substring(5);
            GadgetType type = GadgetType.valueOf(gadget);
            if (type == null) {
                return null;
            }
            return String.valueOf(ultraPlayer.getAmmo(type));
        }
        switch (identifier) {
            case "current_gadget": {
                return ultraPlayer.getCurrentGadget() == null ? "None" : ((GadgetType)ultraPlayer.getCurrentGadget().getType()).getName();
            }
            case "current_mount": {
                return ultraPlayer.getCurrentMount() == null ? "None" : ((MountType)ultraPlayer.getCurrentMount().getType()).getName();
            }
            case "current_particleeffect": {
                return ultraPlayer.getCurrentParticleEffect() == null ? "None" : ((ParticleEffectType)ultraPlayer.getCurrentParticleEffect().getType()).getName();
            }
            case "current_pet": {
                return ultraPlayer.getCurrentPet() == null ? "None" : ((PetType)ultraPlayer.getCurrentPet().getType()).getName();
            }
            case "current_morph": {
                return ultraPlayer.getCurrentMorph() == null ? "None" : ((MorphType)ultraPlayer.getCurrentMorph().getType()).getName();
            }
            case "current_hat": {
                return ultraPlayer.getCurrentHat() == null ? "None" : ((HatType)ultraPlayer.getCurrentHat().getType()).getName();
            }
            case "current_emote": {
                return ultraPlayer.getCurrentEmote() == null ? "None" : ((EmoteType)ultraPlayer.getCurrentEmote().getType()).getName();
            }
            case "current_suit_helmet": {
                return ultraPlayer.getSuit(ArmorSlot.HELMET) == null ? "None" : ((SuitType)ultraPlayer.getSuit(ArmorSlot.HELMET).getType()).getName();
            }
            case "current_suit_chestplate": {
                return ultraPlayer.getSuit(ArmorSlot.CHESTPLATE) == null ? "None" : ((SuitType)ultraPlayer.getSuit(ArmorSlot.CHESTPLATE).getType()).getName();
            }
            case "current_suit_leggings": {
                return ultraPlayer.getSuit(ArmorSlot.LEGGINGS) == null ? "None" : ((SuitType)ultraPlayer.getSuit(ArmorSlot.LEGGINGS).getType()).getName();
            }
            case "current_suit_boots": {
                return ultraPlayer.getSuit(ArmorSlot.BOOTS) == null ? "None" : ((SuitType)ultraPlayer.getSuit(ArmorSlot.BOOTS).getType()).getName();
            }
            case "balance": {
                return "" + ultraPlayer.getBalance();
            }
            case "keys": {
                return "" + ultraPlayer.getKeys();
            }
            case "gadgets_enabled": {
                return "" + ultraPlayer.hasGadgetsEnabled();
            }
            case "morph_selfview": {
                return "" + ultraPlayer.canSeeSelfMorph();
            }
            case "treasurechest_active": {
                return "" + (ultraPlayer.getCurrentTreasureChest() != null);
            }
        }
        return null;
    }

    public String getIdentifier() {
        return "ultracosmetics";
    }

    public String getAuthor() {
        return this.ultraCosmetics.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.ultraCosmetics.getDescription().getVersion();
    }
}

