/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.permissions;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.permissions.PermissionProvider;
import be.isach.ultracosmetics.util.SmartLogger;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.ScopedNode;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LuckPermsHook
implements PermissionProvider {
    private final UltraCosmetics ultraCosmetics;
    private final LuckPerms api;
    private final ImmutableContextSet context;
    private boolean log = true;

    public LuckPermsHook(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        this.api = (LuckPerms)Bukkit.getServicesManager().getRegistration(LuckPerms.class).getProvider();
        String[] contexts = SettingsManager.getConfig().getString("TreasureChests.Permission-Add-Command").split(" ");
        ImmutableContextSet.Builder contextBuilder = ImmutableContextSet.builder();
        for (int i = 1; i < contexts.length; ++i) {
            if (contexts[i].equals("nolog")) {
                this.log = false;
                continue;
            }
            String[] kv = contexts[i].split("=");
            if (kv.length != 2) {
                ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Invalid LuckPerms context: " + contexts[i]);
                continue;
            }
            contextBuilder.add(kv[0], kv[1]);
        }
        this.context = contextBuilder.build();
    }

    @Override
    public void setPermission(final Player player, final String permission) {
        if (this.log) {
            this.ultraCosmetics.getSmartLogger().write("Setting permission '" + permission + "' for user " + player.getName());
        }
        new BukkitRunnable(){

            public void run() {
                User user = LuckPermsHook.this.api.getPlayerAdapter(Player.class).getUser((Object)player);
                ScopedNode node = Node.builder((String)permission).value(true).context((ContextSet)LuckPermsHook.this.context).build();
                user.data().add((Node)node);
                LuckPermsHook.this.api.getUserManager().saveUser(user);
            }
        }.runTaskAsynchronously((Plugin)this.ultraCosmetics);
    }
}

