/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.mysql.StandardQuery;
import be.isach.ultracosmetics.mysql.Table;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.player.profile.CosmeticsProfile;
import be.isach.ultracosmetics.player.profile.ProfileKey;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SqlCache
extends CosmeticsProfile {
    private final Table table;
    private Map<String, Optional<Object>> updateQueue = new ConcurrentHashMap<String, Optional<Object>>();
    private BukkitTask updateTask = null;

    public SqlCache(UltraPlayer ultraPlayer, UltraCosmetics ultraCosmetics) {
        super(ultraPlayer, ultraCosmetics);
        this.table = ultraCosmetics.getMySqlConnectionManager().getTable();
    }

    @Override
    public void load() {
        this.data.loadFromSQL();
    }

    @Override
    public void save() {
    }

    @Override
    public void setEnabledCosmetic(Category cat, CosmeticType<?> type) {
        super.setEnabledCosmetic(cat, type);
        if (cat == Category.SUITS) {
            return;
        }
        this.queueUpdate(Table.cleanCategoryName(cat), (Object)(type == null ? null : Table.cleanCosmeticName(type)));
    }

    @Override
    public void setEnabledSuitPart(ArmorSlot slot, SuitType type) {
        super.setEnabledSuitPart(slot, type);
        this.queueUpdate(Table.cleanCategoryName(Category.SUITS) + "_" + slot.toString().toLowerCase(), (Object)Table.cleanCosmeticName(type));
    }

    @Override
    public void setAmmo(GadgetType type, int amount) {
        super.setAmmo(type, amount);
        this.queueUpdate(Table.cleanCosmeticName(type), (Object)amount);
    }

    @Override
    public void setPetName(PetType type, String name) {
        super.setPetName(type, name);
        this.queueUpdate(Table.cleanCosmeticName(type), (Object)name);
    }

    @Override
    public void setKeys(int amount) {
        super.setKeys(amount);
        this.queueUpdate(ProfileKey.KEYS, (Object)amount);
    }

    @Override
    public void setGadgetsEnabled(boolean gadgetsEnabled) {
        if (gadgetsEnabled == this.hasGadgetsEnabled()) {
            return;
        }
        super.setGadgetsEnabled(gadgetsEnabled);
        this.queueUpdate(ProfileKey.GADGETS_ENABLED, (Object)gadgetsEnabled);
    }

    @Override
    public void setSeeSelfMorph(boolean seeSelfMorph) {
        super.setSeeSelfMorph(seeSelfMorph);
        this.queueUpdate(ProfileKey.MORPH_VIEW, (Object)seeSelfMorph);
    }

    @Override
    public void setTreasureNotifications(boolean treasureNotifications) {
        super.setTreasureNotifications(treasureNotifications);
        this.queueUpdate(ProfileKey.TREASURE_NOTIFICATION, (Object)treasureNotifications);
    }

    @Override
    public void setFilterByOwned(boolean filterByOwned) {
        super.setFilterByOwned(filterByOwned);
        this.queueUpdate(ProfileKey.FILTER_OWNED, (Object)filterByOwned);
    }

    private void queueUpdate(String key, Object value) {
        this.updateQueue.put(key, Optional.ofNullable(value));
        if (this.updateTask == null || !Bukkit.getScheduler().isQueued(this.updateTask.getTaskId())) {
            this.updateTask = new BukkitRunnable(){

                public void run() {
                    StandardQuery query = SqlCache.this.table.update().uuid(SqlCache.this.uuid);
                    SqlCache.this.updateQueue.forEach((k, v) -> query.set((String)k, v.orElse(null)));
                    query.execute();
                    SqlCache.this.updateQueue.clear();
                }
            }.runTaskAsynchronously((Plugin)this.ultraCosmetics);
        }
    }

    private void queueUpdate(ProfileKey key, Object value) {
        this.queueUpdate(key.getSqlKey(), value);
    }
}

