/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.mysql.Column;
import be.isach.ultracosmetics.mysql.HikariHook;
import be.isach.ultracosmetics.mysql.StringColumn;
import be.isach.ultracosmetics.mysql.Table;
import be.isach.ultracosmetics.shaded.hikari.pool.HikariPool;
import be.isach.ultracosmetics.util.SmartLogger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import javax.sql.DataSource;
import org.bukkit.configuration.ConfigurationSection;

public class MySqlConnectionManager {
    public static final int MAX_NAME_SIZE = 64;
    private final String database;
    private final String tableName;
    private final UltraCosmetics ultraCosmetics;
    private Table table;
    private final HikariHook hikariHook;
    private final DataSource dataSource;
    private final String CREATE_TABLE;
    private final List<Column<?>> columns = new ArrayList();
    private final boolean debug;
    private boolean success = true;

    public MySqlConnectionManager(UltraCosmetics ultraCosmetics) {
        HikariHook hook;
        this.ultraCosmetics = ultraCosmetics;
        ConfigurationSection section = SettingsManager.getConfig().getConfigurationSection("MySQL");
        this.debug = section.getBoolean("debug", false);
        String hostname = section.getString("hostname");
        String port = section.getString("port");
        this.database = section.getString("database");
        String username = section.getString("username");
        String password = section.getString("password");
        this.tableName = section.getString("table");
        try {
            hook = new HikariHook(hostname, port, this.database, username, password);
        }
        catch (HikariPool.PoolInitializationException e) {
            this.hikariHook = null;
            this.dataSource = null;
            this.CREATE_TABLE = null;
            this.reportFailure(e);
            return;
        }
        this.hikariHook = hook;
        this.dataSource = this.hikariHook.getDataSource();
        this.columns.add(new Column<String>("uuid", "CHAR(36) CHARACTER SET latin1 PRIMARY KEY", String.class));
        this.columns.add(new Column<Boolean>("gadgetsEnabled", "BOOLEAN DEFAULT TRUE NOT NULL", Boolean.class));
        this.columns.add(new Column<Boolean>("selfmorphview", "BOOLEAN DEFAULT TRUE NOT NULL", Boolean.class));
        this.columns.add(new Column<Boolean>("treasureNotifications", "BOOLEAN DEFAULT TRUE NOT NULL", Boolean.class));
        this.columns.add(new Column<Boolean>("filterByOwned", "BOOLEAN DEFAULT FALSE NOT NULL", Boolean.class));
        this.columns.add(new Column<Integer>("treasureKeys", "INTEGER DEFAULT 0 NOT NULL", Integer.class));
        for (GadgetType gadgetType : GadgetType.values()) {
            this.columns.add(new Column<Integer>(gadgetType.getConfigName().toLowerCase(), "INTEGER DEFAULT 0 NOT NULL", Integer.class));
        }
        for (PetType petType : PetType.values()) {
            this.columns.add(new StringColumn(petType.getConfigName().toLowerCase(), 64, false));
        }
        for (Iterator<CosmeticType> iterator : Category.values()) {
            if (iterator == Category.SUITS) {
                for (ArmorSlot slot : ArmorSlot.values()) {
                    this.columns.add(new StringColumn(((Enum)((Object)iterator)).toString().toLowerCase() + "_" + slot.toString().toLowerCase(), 32, true));
                }
                continue;
            }
            this.columns.add(new StringColumn(((Enum)((Object)iterator)).toString().toLowerCase(), 32, true));
        }
        StringJoiner columnJoiner = new StringJoiner(", ", "(", ")");
        for (Column<?> column : this.columns) {
            columnJoiner.add(column.toString());
        }
        this.CREATE_TABLE = "CREATE TABLE IF NOT EXISTS `" + this.tableName + "`" + columnJoiner.toString() + " ROW_FORMAT=DYNAMIC";
        this.startup();
    }

    public void startup() {
        try (Connection co = this.dataSource.getConnection();){
            if (this.isDebug()) {
                this.ultraCosmetics.getSmartLogger().write("Executing table build SQL: " + this.CREATE_TABLE);
            }
            try (PreparedStatement sql = co.prepareStatement(this.CREATE_TABLE);){
                sql.executeUpdate();
            }
            this.fixTable(co);
            this.table = new Table(this.dataSource, this.tableName);
        }
        catch (SQLException e) {
            this.reportFailure(e);
            return;
        }
    }

    private void reportFailure(Throwable e) {
        this.success = false;
        UltraCosmeticsData.get().setFileStorage(true);
        SmartLogger log = this.ultraCosmetics.getSmartLogger();
        log.write(SmartLogger.LogLevel.ERROR, "Could not connect to MySQL server!");
        log.write(SmartLogger.LogLevel.ERROR, "Error:");
        e.printStackTrace();
    }

    public Table getTable() {
        return this.table;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean success() {
        return this.success;
    }

    public List<Column<?>> getColumns() {
        return this.columns;
    }

    public void shutdown() {
        this.hikariHook.close();
    }

    private void fixTable(Connection co) throws SQLException {
        DatabaseMetaData md = co.getMetaData();
        boolean upgradeAnnounced = false;
        if (this.columnExists("id", md)) {
            this.ultraCosmetics.getSmartLogger().write("You have an old UCData table. Attempting to upgrade it...");
            this.alter(co, "DROP COLUMN id");
            this.alter(co, "DROP COLUMN username");
            this.alter(co, "MODIFY uuid CHAR(36) CHARACTER SET latin1");
            this.alter(co, "ADD PRIMARY KEY (uuid)");
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Column<?> col = this.columns.get(i);
            if (this.isDebug()) {
                this.ultraCosmetics.getSmartLogger().write("Checking column " + col.getName());
            }
            try (ResultSet rs = md.getColumns(this.database, null, this.tableName, col.getName());){
                if (!rs.next()) {
                    if (this.isDebug()) {
                        this.ultraCosmetics.getSmartLogger().write("column " + col.getName() + " does not exist");
                    }
                    if (!upgradeAnnounced) {
                        this.ultraCosmetics.getSmartLogger().write("Upgrading database...");
                        upgradeAnnounced = true;
                    }
                    int j = i - 1;
                    while (!this.columnExists(this.columns.get(j).getName(), md)) {
                        --j;
                    }
                    String afterPrevious = "AFTER " + this.columns.get(j).getName();
                    this.alter(co, "ADD " + col.toString() + " " + afterPrevious);
                    continue;
                }
                if (this.isDebug()) {
                    this.ultraCosmetics.getSmartLogger().write("column exists: " + rs.getString("COLUMN_NAME") + " in " + rs.getString("TABLE_NAME") + " in cat " + rs.getString("TABLE_CAT"));
                }
                if (!(col instanceof StringColumn) || rs.getInt("COLUMN_SIZE") == ((StringColumn)col).getSize()) continue;
                if (this.isDebug()) {
                    this.ultraCosmetics.getSmartLogger().write("column is wrong size, " + rs.getInt("COLUMN_SIZE") + " != " + ((StringColumn)col).getSize());
                }
                if (!upgradeAnnounced) {
                    this.ultraCosmetics.getSmartLogger().write("Upgrading database...");
                    upgradeAnnounced = true;
                }
                this.alter(co, "MODIFY COLUMN " + col.toString());
                continue;
            }
        }
        if (upgradeAnnounced) {
            this.ultraCosmetics.getSmartLogger().write("Upgrade finished.");
        }
    }

    private boolean columnExists(String column, DatabaseMetaData md) throws SQLException {
        try (ResultSet rs = md.getColumns(this.database, null, this.tableName, column);){
            boolean bl = rs.next();
            return bl;
        }
    }

    private void alter(Connection co, String command) throws SQLException {
        String query = "ALTER TABLE `" + this.tableName + "` " + command;
        if (this.isDebug()) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write("Executing SQL: " + query);
        }
        PreparedStatement ps = co.prepareStatement(query);
        ps.execute();
        ps.close();
    }
}

