/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.mysql.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class InsertQuery {
    private final Map<String, String> inserts = new HashMap<String, String>();
    private final Table table;
    private final boolean ignore;

    public InsertQuery(Table table, boolean ignore) {
        this.table = table;
        this.ignore = ignore;
    }

    public InsertQuery(Table table) {
        this(table, false);
    }

    public InsertQuery insert(String key, String value) {
        this.inserts.put(key, value);
        return this;
    }

    public void execute() {
        String sql = "INSERT " + (this.ignore ? "IGNORE " : "") + "INTO " + this.table.getWrappedName() + " ";
        StringJoiner columns = new StringJoiner(", ", "(", ")");
        StringJoiner values = new StringJoiner(", ", "(", ")");
        ArrayList<String> objects = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.inserts.entrySet()) {
            columns.add(entry.getKey());
            values.add("?");
            objects.add(entry.getValue());
        }
        sql = sql + columns.toString() + " VALUES " + values.toString();
        if (UltraCosmeticsData.get().getPlugin().getMySqlConnectionManager().isDebug()) {
            String plaintext = sql.toString();
            for (Object e : objects) {
                plaintext = plaintext.replaceFirst("\\?", e.toString());
            }
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write("Executing SQL: " + plaintext);
        }
        try {
            Connection connection = this.table.getConnection();
            Object object = null;
            try (PreparedStatement throwable = connection.prepareStatement(sql);){
                for (int i = 0; i < objects.size(); ++i) {
                    throwable.setString(i + 1, (String)objects.get(i));
                }
                throwable.executeUpdate();
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            finally {
                if (connection != null) {
                    if (object != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)object).addSuppressed(throwable3);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

