/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql;

import be.isach.ultracosmetics.shaded.hikari.HikariConfig;
import be.isach.ultracosmetics.shaded.hikari.HikariDataSource;
import javax.sql.DataSource;

public class HikariHook {
    private final HikariDataSource dataSource;

    public HikariHook(String hostname, String port, String database, String username, String password) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mysql://" + hostname + ":" + port + "/" + database);
        config.setUsername(username);
        config.setPassword(password);
        config.addDataSourceProperty("prepStmtCacheSize", 250);
        config.addDataSourceProperty("prepStmtCacheSqlLimit", 2048);
        config.addDataSourceProperty("cachePrepStmts", true);
        config.addDataSourceProperty("useServerPrepStmts", true);
        config.addDataSourceProperty("characterEncoding", "utf8");
        config.addDataSourceProperty("useUnicode", true);
        this.dataSource = new HikariDataSource(config);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void close() {
        this.dataSource.close();
    }
}

