/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.menus;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.economy.EconomyHandler;
import be.isach.ultracosmetics.menu.ClickRunnable;
import be.isach.ultracosmetics.menu.Menu;
import be.isach.ultracosmetics.menu.PurchaseData;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.util.ItemFactory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MenuPurchase
extends Menu {
    private String name;
    private PurchaseData purchaseData;

    public MenuPurchase(UltraCosmetics ultraCosmetics, String name, PurchaseData purchaseData) {
        super(ultraCosmetics);
        this.name = name;
        this.purchaseData = purchaseData;
    }

    @Override
    protected void putItems(Inventory inventory, UltraPlayer player) {
        this.putItem(inventory, 13, this.purchaseData.getShowcaseItem());
        ItemStack purchaseItem = ItemFactory.create(XMaterial.EMERALD_BLOCK, MessageManager.getMessage("Purchase"), new String[0]);
        ClickRunnable purchaseClickRunnable = data -> {
            player.getBukkitPlayer().closeInventory();
            EconomyHandler eh = this.getUltraCosmetics().getEconomyHandler();
            if (eh.balance(player.getBukkitPlayer()) < (double)this.purchaseData.getPrice()) {
                player.sendMessage(MessageManager.getMessage("Not-Enough-Money"));
                return;
            }
            eh.withdraw(player.getBukkitPlayer(), this.purchaseData.getPrice());
            player.sendMessage(MessageManager.getMessage("Successful-Purchase"));
            this.purchaseData.getOnPurchase().run();
        };
        for (int i = 27; i < 30; ++i) {
            for (int j = i; j <= i + 18; j += 9) {
                this.putItem(inventory, j, purchaseItem, purchaseClickRunnable);
            }
        }
        ItemStack cancelItem = ItemFactory.create(XMaterial.REDSTONE_BLOCK, MessageManager.getMessage("Cancel"), new String[0]);
        ClickRunnable cancelClickRunnable = data -> this.purchaseData.getOnCancel().run();
        for (int i = 33; i < 36; ++i) {
            for (int j = i; j <= i + 18; j += 9) {
                this.putItem(inventory, j, cancelItem, cancelClickRunnable);
            }
        }
    }

    @Override
    protected int getSize() {
        return 54;
    }

    @Override
    protected String getName() {
        return this.name == null ? "Purchase" : this.name;
    }
}

