/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.menus;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.menu.ClickRunnable;
import be.isach.ultracosmetics.menu.CosmeticMenu;
import be.isach.ultracosmetics.menu.PurchaseData;
import be.isach.ultracosmetics.menu.menus.MenuPurchase;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.version.AnvilGUI;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MenuPets
extends CosmeticMenu<PetType> {
    public MenuPets(UltraCosmetics ultraCosmetics) {
        super(ultraCosmetics, Category.PETS);
    }

    @Override
    protected void putItems(Inventory inventory, UltraPlayer ultraPlayer, int page) {
        this.addPetRenameItem(inventory, ultraPlayer);
    }

    private void addPetRenameItem(Inventory inventory, UltraPlayer player) {
        if (SettingsManager.getConfig().getBoolean("Pets-Rename.Enabled")) {
            ClickRunnable run;
            ItemStack stack;
            int slot = inventory.getSize() - (this.getCategory().hasGoBackArrow() ? 4 : 6);
            if (SettingsManager.getConfig().getBoolean("Pets-Rename.Permission-Required") && !player.hasPermission("ultracosmetics.pets.rename")) {
                return;
            }
            if (player.getCurrentPet() != null) {
                stack = ItemFactory.rename(ItemFactory.getItemStackFromConfig("Categories.Rename-Pet-Item"), MessageManager.getMessage("Menu.Rename-Pet.Button.Name").replace("%petname%", ((PetType)player.getCurrentPet().getType()).getName()));
                run = data -> this.renamePet(player);
            } else {
                stack = ItemFactory.rename(ItemFactory.getItemStackFromConfig("Categories.Rename-Pet-Item"), MessageManager.getMessage("Active-Pet-Needed"));
                run = data -> {
                    player.getBukkitPlayer().sendMessage(MessageManager.getMessage("Active-Pet-Needed"));
                    player.getBukkitPlayer().closeInventory();
                };
            }
            this.putItem(inventory, slot, stack, run);
        }
    }

    public void renamePet(UltraPlayer ultraPlayer) {
        new AnvilGUI.Builder().plugin((Plugin)this.ultraCosmetics).itemLeft(XMaterial.PAPER.parseItem()).text(MessageManager.getMessage("Menu.Rename-Pet.Placeholder")).title(MessageManager.getMessage("Menu.Rename-Pet.Title")).onComplete((player, text) -> {
            String newName = text;
            StringBuilder pattern = new StringBuilder("&#");
            for (int i = 0; i < 6; ++i) {
                pattern.append("([\\da-f])");
            }
            newName = newName.replaceAll(pattern.toString(), "&x&$1&$2&$3&$4&$5&$6");
            if ((newName = ChatColor.translateAlternateColorCodes((char)'&', (String)newName)).length() > 64) {
                return AnvilGUI.Response.text(MessageManager.getMessage("Too-Long"));
            }
            if (SettingsManager.getConfig().getBoolean("Pets-Rename.Requires-Money.Enabled") && this.ultraCosmetics.getEconomyHandler().isUsingEconomy()) {
                return AnvilGUI.Response.openInventory(this.buyRenamePet(ultraPlayer, newName));
            }
            ultraPlayer.setPetName((PetType)ultraPlayer.getCurrentPet().getType(), newName);
            return AnvilGUI.Response.close();
        }).open(ultraPlayer.getBukkitPlayer());
    }

    private Inventory buyRenamePet(UltraPlayer ultraPlayer, String name) {
        String formattedName = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        ItemStack showcaseItem = ItemFactory.create(XMaterial.NAME_TAG, MessageManager.getMessage("Menu.Purchase-Rename.Button.Showcase").replace("%price%", "" + SettingsManager.getConfig().get("Pets-Rename.Requires-Money.Price")).replace("%name%", formattedName), new String[0]);
        PurchaseData purchaseData = new PurchaseData();
        purchaseData.setPrice(SettingsManager.getConfig().getInt("Pets-Rename.Requires-Money.Price"));
        purchaseData.setShowcaseItem(showcaseItem);
        purchaseData.setOnPurchase(() -> {
            ultraPlayer.setPetName((PetType)ultraPlayer.getCurrentPet().getType(), formattedName);
            this.open(ultraPlayer);
        });
        purchaseData.setOnCancel(() -> this.open(ultraPlayer));
        MenuPurchase menu = new MenuPurchase(this.getUltraCosmetics(), MessageManager.getMessage("Menu.Purchase-Rename.Title"), purchaseData);
        return menu.getInventory(ultraPlayer);
    }

    @Override
    protected void filterItem(ItemStack itemStack, PetType cosmeticType, UltraPlayer player) {
        if (player.getPetName(cosmeticType) != null) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(itemMeta.getDisplayName() + ChatColor.GRAY + " (" + player.getPetName(cosmeticType) + ChatColor.GRAY + ")");
            itemStack.setItemMeta(itemMeta);
        }
    }

    @Override
    public List<PetType> enabled() {
        return PetType.enabled();
    }

    @Override
    protected void toggleOn(UltraPlayer ultraPlayer, PetType petType, UltraCosmetics ultraCosmetics) {
        petType.equip(ultraPlayer, ultraCosmetics);
    }
}

