/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.menus;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.menu.ClickRunnable;
import be.isach.ultracosmetics.menu.CosmeticMenu;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.List;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MenuMorphs
extends CosmeticMenu<MorphType> {
    public MenuMorphs(UltraCosmetics ultraCosmetics) {
        super(ultraCosmetics, Category.MORPHS);
    }

    @Override
    protected void putItems(Inventory inventory, UltraPlayer player, int page) {
        this.putSelfViewItem(inventory, player);
    }

    private void putSelfViewItem(Inventory inventory, UltraPlayer player) {
        boolean toggle;
        ItemStack selfViewStack;
        int slot = inventory.getSize() - (this.getCategory().hasGoBackArrow() ? 4 : 6);
        if (player.canSeeSelfMorph()) {
            selfViewStack = ItemFactory.getItemStackFromConfig("Categories.Self-View-Item.When-Enabled");
            toggle = false;
        } else {
            selfViewStack = ItemFactory.getItemStackFromConfig("Categories.Self-View-Item.When-Disabled");
            toggle = true;
        }
        String msg = MessageManager.getMessage((toggle ? "Enable" : "Disable") + "-Third-Person-View");
        ClickRunnable run = data -> {
            player.setSeeSelfMorph(!player.canSeeSelfMorph());
            this.putSelfViewItem(inventory, player);
        };
        this.putItem(inventory, slot, ItemFactory.rename(selfViewStack, msg), run);
    }

    @Override
    protected void filterItem(ItemStack itemStack, MorphType cosmeticType, UltraPlayer player) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        List lore = itemMeta.getLore();
        lore.add("");
        lore.add(cosmeticType.getSkill());
        lore.add("");
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
    }

    @Override
    public List<MorphType> enabled() {
        return MorphType.enabled();
    }

    @Override
    protected void toggleOn(UltraPlayer ultraPlayer, MorphType morphType, UltraCosmetics ultraCosmetics) {
        morphType.equip(ultraPlayer, ultraCosmetics);
    }
}

