/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.menus;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.menu.Menu;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.treasurechests.TreasureChestManager;
import be.isach.ultracosmetics.treasurechests.TreasureRandomizer;
import be.isach.ultracosmetics.util.ItemFactory;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MenuMain
extends Menu {
    private int[] layout;

    public MenuMain(UltraCosmetics ultraCosmetics) {
        super(ultraCosmetics);
        switch (Category.enabledSize()) {
            case 8: {
                this.layout = new int[]{10, 12, 14, 16, 28, 30, 32, 34};
                break;
            }
            case 7: {
                this.layout = new int[]{10, 13, 16, 28, 30, 32, 34};
                break;
            }
            case 6: {
                this.layout = new int[]{10, 13, 16, 28, 31, 34};
                break;
            }
            case 5: {
                this.layout = new int[]{10, 16, 22, 29, 33};
                break;
            }
            case 4: {
                this.layout = new int[]{19, 21, 23, 25};
                break;
            }
            case 3: {
                this.layout = new int[]{20, 22, 24};
                break;
            }
            case 2: {
                this.layout = new int[]{21, 23};
                break;
            }
            case 1: {
                this.layout = new int[]{22};
            }
        }
        if (UltraCosmeticsData.get().areTreasureChestsEnabled() && this.layout != null) {
            int i = 0;
            while (i < this.layout.length) {
                int n = i++;
                this.layout[n] = this.layout[n] + 9;
            }
        }
    }

    @Override
    public void open(UltraPlayer player) {
        if (!UltraCosmeticsData.get().areTreasureChestsEnabled() && Category.enabledSize() == 1) {
            this.getUltraCosmetics().getMenus().getCategoryMenu(Category.enabled().get(0)).open(player);
            return;
        }
        super.open(player);
    }

    @Override
    protected void putItems(Inventory inventory, UltraPlayer player) {
        if (Category.enabledSize() > 0) {
            for (int i = 0; i < Category.enabledSize(); ++i) {
                int slot = this.layout[i];
                Category category = Category.enabled().get(i);
                this.putItem(inventory, slot, category.getItemStack(), data -> this.getUltraCosmetics().getMenus().getCategoryMenu(category).open(player));
            }
        }
        String message = MessageManager.getMessage("Clear.Cosmetics");
        ItemStack itemStack = ItemFactory.rename(ItemFactory.getItemStackFromConfig("Categories.Clear-Cosmetic-Item"), message);
        this.putItem(inventory, inventory.getSize() - 5, itemStack, data -> {
            player.clear();
            this.open(player);
        });
        if (UltraCosmeticsData.get().areTreasureChestsEnabled()) {
            String msgChests = MessageManager.getMessage("Treasure-Chests");
            boolean usingEconomy = this.getUltraCosmetics().getEconomyHandler().isUsingEconomy();
            boolean canBuyKeys = usingEconomy && SettingsManager.getConfig().getInt("TreasureChests.Key-Price") > 0;
            String buyKeyMessage = "";
            if (canBuyKeys) {
                buyKeyMessage = "\n" + MessageManager.getMessage("Click-Buy-Key") + "\n";
            }
            String[] chestLore = player.getKeys() < 1 ? new String[]{"", MessageManager.getMessage("Dont-Have-Key"), buyKeyMessage} : (SettingsManager.getConfig().getString("TreasureChests.Mode", "").equalsIgnoreCase("both") ? new String[]{"", MessageManager.getMessage("Left-Click-Open-Chest"), MessageManager.getMessage("Right-Click-Simple"), ""} : new String[]{"", MessageManager.getMessage("Click-Open-Chest"), ""});
            ItemStack keys = ItemFactory.create(XMaterial.TRIPWIRE_HOOK, MessageManager.getMessage("Treasure-Keys"), "", MessageManager.getMessage("Your-Keys").replace("%keys%", String.valueOf(player.getKeys())), buyKeyMessage);
            this.putItem(inventory, 5, keys, data -> {
                if (!canBuyKeys) {
                    XSound.BLOCK_ANVIL_LAND.play(player.getBukkitPlayer().getLocation(), 0.2f, 1.2f);
                    return;
                }
                player.getBukkitPlayer().closeInventory();
                player.openKeyPurchaseMenu();
            });
            ItemStack chest = ItemFactory.create(XMaterial.CHEST, msgChests, chestLore);
            this.putItem(inventory, 3, chest, data -> {
                if (!canBuyKeys && player.getKeys() < 1) {
                    XSound.BLOCK_ANVIL_LAND.play(player.getBukkitPlayer().getLocation(), 0.2f, 1.2f);
                    return;
                }
                String mode = SettingsManager.getConfig().getString("TreasureChests.Mode", "structure");
                if (mode.equalsIgnoreCase("both")) {
                    mode = data.getClick().isRightClick() ? "simple" : "structure";
                }
                if (player.getKeys() > 0 && mode.equalsIgnoreCase("simple")) {
                    player.removeKey();
                    int count = SettingsManager.getConfig().getInt("TreasureChests.Count", 4);
                    TreasureRandomizer tr = new TreasureRandomizer(player.getBukkitPlayer(), player.getBukkitPlayer().getLocation(), true);
                    for (int i = 0; i < count; ++i) {
                        tr.giveRandomThing();
                    }
                    this.open(player);
                } else {
                    TreasureChestManager.tryOpenChest(player.getBukkitPlayer());
                }
            });
        }
    }

    @Override
    protected String getName() {
        return MessageManager.getMessage("Menu.Main.Title");
    }

    @Override
    protected int getSize() {
        return UltraCosmeticsData.get().areTreasureChestsEnabled() ? 54 : 45;
    }

    public static void openMainMenu(UltraPlayer ultraPlayer) {
        UltraCosmetics ultraCosmetics = UltraCosmeticsData.get().getPlugin();
        if (ultraCosmetics.getConfig().getBoolean("Categories.Back-To-Main-Menu-Custom-Command.Enabled")) {
            String command = ultraCosmetics.getConfig().getString("Categories.Back-To-Main-Menu-Custom-Command.Command").replace("/", "").replace("{player}", ultraPlayer.getBukkitPlayer().getName()).replace("{playeruuid}", ultraPlayer.getUUID().toString());
            Bukkit.dispatchCommand((CommandSender)ultraCosmetics.getServer().getConsoleSender(), (String)command);
        } else {
            ultraCosmetics.getMenus().getMainMenu().open(ultraPlayer);
        }
    }
}

