/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.menu.CosmeticMenu;
import be.isach.ultracosmetics.menu.PurchaseData;
import be.isach.ultracosmetics.menu.menus.MenuEmotes;
import be.isach.ultracosmetics.menu.menus.MenuGadgets;
import be.isach.ultracosmetics.menu.menus.MenuHats;
import be.isach.ultracosmetics.menu.menus.MenuMain;
import be.isach.ultracosmetics.menu.menus.MenuMorphs;
import be.isach.ultracosmetics.menu.menus.MenuMounts;
import be.isach.ultracosmetics.menu.menus.MenuParticleEffects;
import be.isach.ultracosmetics.menu.menus.MenuPets;
import be.isach.ultracosmetics.menu.menus.MenuPurchase;
import be.isach.ultracosmetics.menu.menus.MenuSuits;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class Menus {
    private final UltraCosmetics ultraCosmetics;
    private final Map<Category, CosmeticMenu<?>> categoryMenus = new HashMap();
    private final MenuMain mainMenu;

    public Menus(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        this.categoryMenus.put(Category.EMOTES, new MenuEmotes(ultraCosmetics));
        this.categoryMenus.put(Category.GADGETS, new MenuGadgets(ultraCosmetics));
        this.categoryMenus.put(Category.EFFECTS, new MenuParticleEffects(ultraCosmetics));
        this.categoryMenus.put(Category.HATS, new MenuHats(ultraCosmetics));
        this.categoryMenus.put(Category.MORPHS, new MenuMorphs(ultraCosmetics));
        this.categoryMenus.put(Category.MOUNTS, new MenuMounts(ultraCosmetics));
        this.categoryMenus.put(Category.PETS, new MenuPets(ultraCosmetics));
        this.categoryMenus.put(Category.SUITS, new MenuSuits(ultraCosmetics));
        this.mainMenu = new MenuMain(ultraCosmetics);
    }

    public MenuMain getMainMenu() {
        return this.mainMenu;
    }

    public CosmeticMenu<?> getCategoryMenu(Category category) {
        return this.categoryMenus.get((Object)category);
    }

    public void openAmmoPurchaseMenu(GadgetType type, UltraPlayer player) {
        String itemName = MessageManager.getMessage("Buy-Ammo-Description");
        itemName = itemName.replace("%amount%", String.valueOf(type.getResultAmmoAmount()));
        itemName = itemName.replace("%price%", String.valueOf(type.getAmmoPrice()));
        itemName = itemName.replace("%gadgetname%", type.getName());
        ItemStack display = ItemFactory.create(type.getMaterial(), itemName, new String[0]);
        PurchaseData pd = new PurchaseData();
        MenuGadgets mg = (MenuGadgets)this.categoryMenus.get((Object)Category.GADGETS);
        pd.setPrice(type.getAmmoPrice());
        pd.setShowcaseItem(display);
        pd.setOnPurchase(() -> {
            player.addAmmo(type, type.getResultAmmoAmount());
            mg.open(player, player.getGadgetsPage());
            player.setGadgetsPage(1);
        });
        pd.setOnCancel(() -> {
            mg.open(player, player.getGadgetsPage());
            player.setGadgetsPage(1);
        });
        MenuPurchase mp = new MenuPurchase(this.ultraCosmetics, MessageManager.getMessage("Menu.Buy-Ammo.Title"), pd);
        player.getBukkitPlayer().openInventory(mp.getInventory(player));
    }
}

