/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.menu.ClickData;
import be.isach.ultracosmetics.menu.ClickRunnable;
import be.isach.ultracosmetics.menu.CosmeticsInventoryHolder;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public abstract class Menu
implements Listener {
    protected UltraCosmetics ultraCosmetics;
    private Map<Inventory, Map<ItemStack, ClickRunnable>> clickRunnableMap = new HashMap<Inventory, Map<ItemStack, ClickRunnable>>();

    public Menu(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        ultraCosmetics.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ultraCosmetics);
    }

    public void open(UltraPlayer player) {
        player.getBukkitPlayer().openInventory(this.getInventory(player));
    }

    public Inventory getInventory(UltraPlayer player) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new CosmeticsInventoryHolder(), (int)this.getSize(), (String)this.getName());
        this.putItems(inventory, player);
        ItemFactory.fillInventory(inventory);
        return inventory;
    }

    protected void putItem(Inventory inventory, int slot, ItemStack itemStack, ClickRunnable clickRunnable) {
        Validate.notNull((Object)itemStack);
        Validate.notNull((Object)clickRunnable);
        if (itemStack.hasItemMeta()) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.addItemFlags(ItemFlag.values());
            itemStack.setItemMeta(itemMeta);
        }
        inventory.setItem(slot, itemStack);
        Map map = this.clickRunnableMap.computeIfAbsent(inventory, f -> new HashMap());
        map.put(itemStack, clickRunnable);
    }

    protected void putItem(Inventory inventory, int slot, ItemStack itemStack) {
        this.putItem(inventory, slot, itemStack, data -> {});
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (event.getInventory() == null) {
            return;
        }
        if (event.getCurrentItem() == null || !event.getCurrentItem().hasItemMeta() || !event.getCurrentItem().getItemMeta().hasDisplayName()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!event.getView().getTitle().startsWith(this.getName())) {
            return;
        }
        if (!this.clickRunnableMap.containsKey(event.getInventory())) {
            return;
        }
        if (event.getCurrentItem().equals((Object)ItemFactory.fillerItem)) {
            event.setCancelled(true);
            return;
        }
        ClickRunnable clickRunnable = null;
        String clickItemName = event.getCurrentItem().getItemMeta().getDisplayName();
        Set<Map.Entry<ItemStack, ClickRunnable>> entries = this.clickRunnableMap.get(event.getInventory()).entrySet();
        for (Map.Entry<ItemStack, ClickRunnable> entry : entries) {
            if (!entry.getKey().getItemMeta().getDisplayName().equals(clickItemName)) continue;
            clickRunnable = entry.getValue();
            break;
        }
        if (clickRunnable == null) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        UltraPlayer ultraPlayer = this.ultraCosmetics.getPlayerManager().getUltraPlayer(player);
        clickRunnable.run(new ClickData(event.getInventory(), ultraPlayer, event.getClick(), event.getCurrentItem(), event.getSlot()));
        player.updateInventory();
    }

    public UltraCosmetics getUltraCosmetics() {
        return this.ultraCosmetics;
    }

    protected abstract void putItems(Inventory var1, UltraPlayer var2);

    protected abstract int getSize();

    protected abstract String getName();
}

