/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticEntType;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.menu.ClickData;
import be.isach.ultracosmetics.menu.CosmeticsInventoryHolder;
import be.isach.ultracosmetics.menu.Menu;
import be.isach.ultracosmetics.menu.PurchaseData;
import be.isach.ultracosmetics.menu.menus.MenuMain;
import be.isach.ultracosmetics.menu.menus.MenuPurchase;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Difficulty;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public abstract class CosmeticMenu<T extends CosmeticType<?>>
extends Menu {
    public static final int[] COSMETICS_SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
    protected Category category;

    public CosmeticMenu(UltraCosmetics ultraCosmetics, Category category) {
        super(ultraCosmetics);
        this.category = category;
    }

    @Override
    public void open(UltraPlayer player) {
        this.open(player, 1);
    }

    public void open(UltraPlayer player, int page) {
        int maxPages = this.getMaxPages(player);
        if (page > maxPages) {
            page = maxPages;
        }
        if (page < 1) {
            page = 1;
        }
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new CosmeticsInventoryHolder(), (int)this.getSize(), (String)(maxPages == 1 ? this.getName() : this.getName(page, player)));
        boolean hasUnlockable = false;
        for (Object type : this.enabled()) {
            if (player.hasPermission(((CosmeticType)type).getPermission())) continue;
            hasUnlockable = true;
            break;
        }
        Map<Integer, T> slots = this.getSlots(page, player);
        for (Map.Entry entry : slots.entrySet()) {
            boolean deactivate;
            int slot = (Integer)entry.getKey();
            CosmeticType cosmeticType = (CosmeticType)entry.getValue();
            if (this.shouldHideItem(player, cosmeticType)) continue;
            int price = SettingsManager.getConfig().getInt(cosmeticType.getConfigPath() + ".Purchase-Price");
            if (SettingsManager.getConfig().getBoolean("No-Permission.Custom-Item.enabled") && !player.hasPermission(cosmeticType.getPermission())) {
                ItemStack stack = ItemFactory.getItemStackFromConfig("No-Permission.Custom-Item.Type");
                String name = ChatColor.translateAlternateColorCodes((char)'&', (String)SettingsManager.getConfig().getString("No-Permission.Custom-Item.Name")).replace("{cosmetic-name}", cosmeticType.getName());
                List npLore = SettingsManager.getConfig().getStringList("No-Permission.Custom-Item.Lore");
                this.addPurchaseLore(price, npLore, cosmeticType, player);
                String[] array = new String[npLore.size()];
                npLore.toArray(array);
                this.putItem(inventory, slot, ItemFactory.rename(stack, name, array), clickData -> {
                    Player clicker = clickData.getClicker().getBukkitPlayer();
                    clicker.sendMessage(MessageManager.getMessage("No-Permission"));
                    clicker.closeInventory();
                });
                continue;
            }
            String toggle = this.category.getActivateTooltip();
            boolean bl = deactivate = player.hasCosmetic(this.category) && player.getCosmetic(this.category).getType() == cosmeticType;
            if (deactivate) {
                toggle = this.category.getDeactivateTooltip();
            }
            String typeName = this.getTypeName(cosmeticType, player);
            ItemStack is = ItemFactory.rename(cosmeticType.getItemStack(), toggle + " " + typeName);
            if (deactivate) {
                ItemFactory.addGlow(is);
            }
            ItemMeta itemMeta = is.getItemMeta();
            ArrayList<String> loreList = new ArrayList<String>();
            if (cosmeticType.showsDescription()) {
                loreList.add("");
                loreList.addAll(cosmeticType.getDescription());
                loreList.add("");
            }
            if (SettingsManager.getConfig().getBoolean("No-Permission.Show-In-Lore")) {
                String yesOrNo = player.hasPermission(cosmeticType.getPermission()) ? "Yes" : "No";
                String s = SettingsManager.getConfig().getString("No-Permission.Lore-Message-" + yesOrNo);
                loreList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
            }
            this.addPurchaseLore(price, loreList, cosmeticType, player);
            itemMeta.setLore(loreList);
            is.setItemMeta(itemMeta);
            this.filterItem(is, cosmeticType, player);
            this.putItem(inventory, slot, is, data -> {
                boolean success = this.handleClick(data, cosmeticType, price);
                if (success && UltraCosmeticsData.get().shouldCloseAfterSelect()) {
                    data.getClicker().getBukkitPlayer().closeInventory();
                }
            });
        }
        if (page > 1) {
            int finalPage = page;
            this.putItem(inventory, this.getSize() - 18, ItemFactory.rename(ItemFactory.getItemStackFromConfig("Categories.Previous-Page-Item"), MessageManager.getMessage("Menu.Misc.Button.Previous-Page")), data -> this.open(player, finalPage - 1));
        }
        if (page < maxPages) {
            int finalPage = page;
            this.putItem(inventory, this.getSize() - 10, ItemFactory.rename(ItemFactory.getItemStackFromConfig("Categories.Next-Page-Item"), MessageManager.getMessage("Menu.Misc.Button.Next-Page")), data -> this.open(player, finalPage + 1));
        }
        String message = MessageManager.getMessage("Clear." + this.category.getConfigPath());
        ItemStack itemStack = ItemFactory.rename(ItemFactory.getItemStackFromConfig("Categories.Clear-Cosmetic-Item"), message);
        this.putItem(inventory, inventory.getSize() - 5, itemStack, data -> {
            this.toggleOff(player, null);
            this.open(player, this.getCurrentPage(player));
        });
        if (this.getCategory().hasGoBackArrow()) {
            ItemStack item = ItemFactory.rename(ItemFactory.getItemStackFromConfig("Categories.Back-Main-Menu-Item"), MessageManager.getMessage("Menu.Main.Title"));
            this.putItem(inventory, inventory.getSize() - 6, item, data -> MenuMain.openMainMenu(player));
        }
        if (hasUnlockable && !SettingsManager.getConfig().getBoolean("No-Permission.Dont-Show-Item")) {
            String filterItemName = player.isFilteringByOwned() ? MessageManager.getMessage("Disable-Filter-By-Owned") : MessageManager.getMessage("Enable-Filter-By-Owned");
            ItemStack filterItem = ItemFactory.create(XMaterial.HOPPER, filterItemName, new String[0]);
            int finalPage = page;
            this.putItem(inventory, inventory.getSize() - 3, filterItem, data -> {
                player.setFilteringByOwned(!player.isFilteringByOwned());
                this.open(player, finalPage);
            });
        }
        this.putItems(inventory, player, page);
        ItemFactory.fillInventory(inventory);
        player.getBukkitPlayer().openInventory(inventory);
    }

    private void addPurchaseLore(int price, List<String> lore, T cosmeticType, UltraPlayer player) {
        if (price > 0 && !player.hasPermission(((CosmeticType)cosmeticType).getPermission()) && SettingsManager.getConfig().getBoolean("No-Permission.Allow-Purchase")) {
            lore.add("");
            lore.add(MessageManager.getMessage("Click-To-Purchase").replace("%price%", String.valueOf(price)));
        }
    }

    public T getCosmeticType(String name) {
        for (CosmeticType effectType : this.enabled()) {
            if (!effectType.getConfigName().replace(" ", "").equals(name.replace(" ", ""))) continue;
            return (T)effectType;
        }
        return null;
    }

    protected int getCurrentPage(UltraPlayer ultraPlayer) {
        Player player = ultraPlayer.getBukkitPlayer();
        String title = player.getOpenInventory().getTitle();
        if (player.getOpenInventory() != null && title.startsWith(this.getName()) && !title.equals(this.getName())) {
            String s = player.getOpenInventory().getTitle().replace(this.getName() + " " + ChatColor.GRAY + "" + ChatColor.ITALIC + "(", "").replace("/" + this.getMaxPages(ultraPlayer) + ")", "");
            return Integer.parseInt(s);
        }
        return 0;
    }

    protected int getMaxPages(UltraPlayer player) {
        int i = 0;
        for (CosmeticType type : this.enabled()) {
            if (this.shouldHideItem(player, type)) continue;
            ++i;
        }
        return Math.max(1, (i - 1) / 21 + 1);
    }

    protected int getItemsPerPage() {
        return 21;
    }

    protected void filterItem(ItemStack itemStack, T cosmeticType, UltraPlayer player) {
    }

    protected String getTypeName(T cosmeticType, UltraPlayer ultraPlayer) {
        return ((CosmeticType)cosmeticType).getName();
    }

    protected String getName(int page, UltraPlayer ultraPlayer) {
        return MessageManager.getMessage("Menu." + this.category.getConfigPath() + ".Title") + " " + ChatColor.GRAY + "" + ChatColor.ITALIC + "(" + page + "/" + this.getMaxPages(ultraPlayer) + ")";
    }

    @Override
    protected int getSize() {
        return 54;
    }

    @Override
    protected void putItems(Inventory inventory, UltraPlayer ultraPlayer) {
    }

    @Override
    protected String getName() {
        return MessageManager.getMessage("Menu." + this.category.getConfigPath() + ".Title");
    }

    public Category getCategory() {
        return this.category;
    }

    protected void putItems(Inventory inventory, UltraPlayer ultraPlayer, int page) {
    }

    public abstract List<T> enabled();

    protected Map<Integer, T> getSlots(int page, UltraPlayer player) {
        int start = 21 * (page - 1);
        int limit = 21;
        int current = 0;
        HashMap slots = new HashMap();
        ArrayList<T> enabled = new ArrayList<T>(this.enabled());
        enabled.removeIf(k -> this.shouldHideItem(player, (CosmeticType<?>)k));
        for (int i = start; current < limit && i < enabled.size(); ++i) {
            slots.put(COSMETICS_SLOTS[current++ % 21], enabled.get(i));
        }
        return slots;
    }

    protected abstract void toggleOn(UltraPlayer var1, T var2, UltraCosmetics var3);

    protected void toggleOff(UltraPlayer ultraPlayer, T type) {
        ultraPlayer.removeCosmetic(this.category);
    }

    protected void handleRightClick(UltraPlayer ultraPlayer, T type) {
    }

    protected boolean handleActivate(UltraPlayer ultraPlayer) {
        if (!UltraCosmeticsData.get().shouldCloseAfterSelect()) {
            this.open(ultraPlayer, this.getCurrentPage(ultraPlayer));
        }
        return true;
    }

    protected boolean handleClick(ClickData data, T cosmeticType, int price) {
        UltraPlayer ultraPlayer = data.getClicker();
        ItemStack clicked = data.getClicked();
        int currentPage = this.getCurrentPage(ultraPlayer);
        if (data.getClick().isRightClick() && ultraPlayer.hasPermission(((CosmeticType)cosmeticType).getPermission())) {
            this.handleRightClick(ultraPlayer, cosmeticType);
            return false;
        }
        if (this.startsWithColorless(clicked.getItemMeta().getDisplayName(), this.category.getDeactivateTooltip())) {
            this.toggleOff(ultraPlayer, cosmeticType);
            if (!UltraCosmeticsData.get().shouldCloseAfterSelect()) {
                this.open(ultraPlayer, currentPage);
            }
        } else if (this.startsWithColorless(clicked.getItemMeta().getDisplayName(), this.category.getActivateTooltip())) {
            if (ultraPlayer.hasPermission(((CosmeticType)cosmeticType).getPermission())) {
                this.toggleOn(ultraPlayer, cosmeticType, this.getUltraCosmetics());
                if (this.hasEquipped(ultraPlayer, cosmeticType)) {
                    return this.handleActivate(ultraPlayer);
                }
                return true;
            }
            if (!SettingsManager.getConfig().getBoolean("No-Permission.Allow-Purchase") || price <= 0) {
                ultraPlayer.sendMessage(MessageManager.getMessage("No-Permission"));
                return true;
            }
            String itemName = MessageManager.getMessage("Buy-Cosmetic-Description");
            itemName = itemName.replace("%price%", String.valueOf(price));
            itemName = itemName.replace("%gadgetname%", ((CosmeticType)cosmeticType).getName());
            ItemStack display = ItemFactory.rename(((CosmeticType)cosmeticType).getItemStack(), itemName);
            PurchaseData pd = new PurchaseData();
            pd.setPrice(price);
            pd.setShowcaseItem(display);
            pd.setOnPurchase(() -> {
                this.ultraCosmetics.getPermissionProvider().setPermission(ultraPlayer.getBukkitPlayer(), cosmeticType.getPermission());
                Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
                    cosmeticType.equip(ultraPlayer, this.getUltraCosmetics());
                    this.open(ultraPlayer);
                }, 5L);
            });
            pd.setOnCancel(() -> this.open(ultraPlayer));
            MenuPurchase mp = new MenuPurchase(this.getUltraCosmetics(), "Purchase " + ((CosmeticType)cosmeticType).getName(), pd);
            ultraPlayer.getBukkitPlayer().openInventory(mp.getInventory(ultraPlayer));
            return false;
        }
        return true;
    }

    protected boolean startsWithColorless(String a, String b) {
        return ChatColor.stripColor((String)a).startsWith(ChatColor.stripColor((String)b));
    }

    protected boolean shouldHideItem(UltraPlayer player, CosmeticType<?> cosmeticType) {
        if ((SettingsManager.getConfig().getBoolean("No-Permission.Dont-Show-Item") || player.isFilteringByOwned()) && !player.hasPermission(cosmeticType.getPermission())) {
            return true;
        }
        return cosmeticType instanceof CosmeticEntType && ((CosmeticEntType)cosmeticType).isMonster() && player.getBukkitPlayer().getWorld().getDifficulty() == Difficulty.PEACEFUL;
    }

    protected boolean hasEquipped(UltraPlayer ultraPlayer, T type) {
        return ultraPlayer.hasCosmetic(((CosmeticType)type).getCategory());
    }
}

